package com.biz.crm.cps.business.signtask.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @description: 签收活动列表
 * @author: rentao
 * @date: 2021/12/20 16:13
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SignTaskEntity", description = "签收活动列表")
@TableName("sign_task")
public class SignTask extends TenantFlagOpEntity {
  private static final long serialVersionUID = 4152275804637321581L;

  /**
   * 签收活动编码
   */
  @Column(name = "sign_task_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 签收活动编码 '")
  @ApiModelProperty(value = "签收活动编码",required = true)
  @TableField(value = "sign_task_code")
  private String signTaskCode;

  /**
   * 签收活动名称
   */
  @Column(name = "sign_task_name",nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 签收活动名称 '")
  @ApiModelProperty(value = "签收活动名称",required = true)
  @TableField(value = "sign_task_name")
  private String signTaskName;

  /**
   * 签收金额
   */
  @ApiModelProperty("签收金额")
  @TableField(value = "sign_task_amount")
  @Column(name = "sign_task_amount", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 签收金额 '")
  private BigDecimal signTaskAmount;

  /**
   * 是否拍照
   */
  @TableField(value = "photograph")
  @ApiModelProperty(value = "是否拍照",required = true)
  @Column(name = "photograph", columnDefinition = "int COMMENT '是否拍照'")
  private Boolean photograph = false;

  /**
   * 签收有效期开始日期
   */
  @Column(name = "sign_task_start_time", nullable = false, columnDefinition = "datetime COMMENT ' 签收有效期开始日期 '")
  @ApiModelProperty(value = "签收有效期开始日期",required = true)
  @TableField(value = "sign_task_start_time")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date signTaskStartTime;

  /**
   * 签收有效期结束日期
   */
  @Column(name = "sign_task_end_time", nullable = false, columnDefinition = "datetime COMMENT ' 签收有效期结束日期 '")
  @ApiModelProperty(value = "签收有效期结束日期",required = true)
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @TableField(value = "sign_task_end_time")
  private Date signTaskEndTime;

  /**
   * 权限类型：0全部终端门店，1部分终端门店，2指定终端门店
   */
  @ApiModelProperty(value = "权限类型：0全部终端门店，1部分终端门店，2指定终端门店" ,required = true)
  @TableField("permission_type")
  @Column(name = "permission_type",nullable = false, length = 10, columnDefinition = "int COMMENT ' 权限类型：0全部终端门店，1部分终端门店，2指定终端门店 '")
  private Integer permissionType;

  /**
   * 活动类型：0实物；1现金
   * */
  @ApiModelProperty(value = "活动类型：1实物；2现金" ,required = true)
  @TableField(value = "sign_task_type")
  @Column(name = "sign_task_type",nullable = false, length = 10, columnDefinition = "int COMMENT ' 活动类型：1实物；2现金 '")
  private Integer signTaskType;

  /**
   * 签约客户类型 0 经销商  1 终端
   */
  @Column(name = "sign_type",nullable = false, length = 10, columnDefinition = "int COMMENT ' 签约客户类型 0 经销商  1 终端 '")
  @ApiModelProperty(value = "签约客户类型 0 经销商  1 终端" ,required = true)
  @TableField(value = "sign_type")
  private Integer signType;

  /**
   * 关联标签
   */
  @ApiModelProperty("关联标签")
  @TableField(exist = false)
  private Set<SignTaskTagRelationship> signTaskTagRelationships;

  /**
   * 关联包含渠道
   */
  @ApiModelProperty("关联包含渠道")
  @TableField(exist = false)
  private Set<SignTaskChannelRelationship> signTaskChannelRelationships;

  /**
   * 关联所属组织列表
   */
  @ApiModelProperty("关联所属组织列表")
  @TableField(exist = false)
  private Set<SignTaskOrgRelationship> signTaskOrgRelationships;

  /**
   * 关联终端门店编码集合
   */
  @ApiModelProperty("关联终端门店编码集合")
  @TableField(exist = false)
  private Set<SignTaskTerminalRelationship> signTaskTerminalRelationships;

  /**
   * 关联客户编码集合
   */
  @ApiModelProperty("关联客户编码集合")
  @TableField(exist = false)
  private Set<SignTaskCusRelationship> signTaskCusRelationships;

  /**
   * 关联物料信息集合
   */
  @ApiModelProperty("关联物料信息集合")
  @TableField(exist = false)
  private Set<SignTaskMaterialRelationship> signTaskMaterialRelationships;
}
