package com.biz.crm.cps.business.signtask.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @description: 活动签收任务主表
 * @author: rentao
 * @date: 2021/12/23 14:48
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SignTaskActivity", description = "活动签收任务主表")
@TableName("sign_task_activity")
public class SignTaskActivity extends TenantFlagOpEntity {

  /**
   * 签收任务编码
   */
  @Column(name = "sign_task_activity_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 签收任务编码 '")
  @ApiModelProperty("签收任务编码")
  @TableField(value = "sign_task_activity_code")
  private String signTaskActivityCode;

  /**
   * 关联活动类型
   */
  @Column(name = "sign_task_activity_type", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 关联活动类型 '")
  @ApiModelProperty("关联活动类型")
  @TableField(value = "sign_task_activity_type")
  private Integer signTaskActivityType;

  /**
   * 所属组织编码
   */
  @Column(name = "org_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 所属组织编码 '")
  @ApiModelProperty("所属组织编码")
  @TableField(value = "org_code")
  private String orgCode;

  /**
   * 所属组织名称
   */
  @Column(name = "org_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 所属组织名称 '")
  @ApiModelProperty("所属组织名称")
  @TableField(value = "org_name")
  private String orgName;

  /**
   * 客户所属组织编码
   */

  @Column(name = "client_org_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 客户所属组织编码 '")
  @ApiModelProperty("客户所属组织编码")
  @TableField(value = "client_org_code")
  private String clientOrgCode;

  /**
   * 客户所属组织名称
   */
  @Column(name = "client_org_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 客户所属组织名称 '")
  @ApiModelProperty("客户所属组织名称")
  @TableField(value = "client_org_name")
  private String clientOrgName;

  /**
   * 渠道编码
   */
  @Column(name = "channel_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 渠道编码 '")
  @TableField(value = "channel_code")
  @ApiModelProperty("渠道编码")
  private String channelCode;

  /**
   * 渠道名称
   */
  @Column(name = "channel_name",length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 渠道名称 '")
  @TableField(value = "channel_name")
  @ApiModelProperty("渠道名称")
  private String channelName;

  /**
   * 客户分类 0经销商 ,1终端
   */
  @Column(name = "client_classify", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户分类 0经销商 ,1终端 '")
  @ApiModelProperty("客户分类 0经销商 1终端")
  @TableField(value = "client_classify")
  private Integer clientClassify;

  /**
   * 经销商/终端类型
   */
  @Column(name = "client_type", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 经销商/终端类型 '")
  @ApiModelProperty(" 经销商/终端类型")
  @TableField(value = "client_type")
  private String clientType;

  /**
   * 标签名称
   */
  @Column(name = "tag_name",  length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 标签名称 '")
  @ApiModelProperty(" 标签名称")
  @TableField(value = "tag_name")
  private String tagName;

  /**
   * 客户编码
   */
  @Column(name = "client_code", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' client_code '")
  @ApiModelProperty("客户编码")
  @TableField(value = "client_code")
  private String clientCode;

  /**
   * 客户名称
   */
  @Column(name = "client_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 客户名称 '")
  @ApiModelProperty("客户名称")
  @TableField(value = "client_name")
  private String clientName;

  /**
   * 签收状态：0 未签收；1已签收 2 已过期
   */
  @ApiModelProperty("签收状态：0 未签收；1已签收 2 已过期 ")
  @Column(name = "sign_task_status", length = 10, nullable = false,columnDefinition = "int(10) NOT NULL COMMENT '签收状态：0 未签收；1已签收 2 已过期'")
  @TableField(value = "sign_task_status")
  private Integer signTaskStatus;

  /**
   * 签收活动编码
   */
  @Column(name = "sign_task_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 签收活动编码 '")
  @ApiModelProperty("签收活动编码")
  @TableField(value = "sign_task_code")
  private String signTaskCode;

  /**
   * 签收活动名称
   */
  @Column(name = "sign_task_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 签收活动名称 '")
  @ApiModelProperty("签收活动名称")
  @TableField(value = "sign_task_name")
  private String signTaskName;

  /**
   * 签收有效期开始日期
   */
  @Column(name = "sign_task_start_time", nullable = false, columnDefinition = "datetime COMMENT ' 签收有效期开始日期 '")
  @ApiModelProperty("签收有效期开始日期")
  @TableField(value = "sign_task_start_time")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date signTaskStartTime;

  /**
   * 签收有效期结束日期
   */
  @Column(name = "sign_task_end_time", nullable = false, columnDefinition = "datetime COMMENT ' 签收有效期结束日期 '")
  @ApiModelProperty("签收有效期结束日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @TableField(value = "sign_task_end_time")
  private Date signTaskEndTime;

  /**
   * 签收日期
   */
  @Column(name = "sign_date", columnDefinition = "datetime COMMENT ' 签收日期 '")
  @ApiModelProperty("签收日期")
  @TableField(value = "sign_date")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date signDate;

  /**
   * 是否拍照
   */
  @TableField(value = "photograph")
  @ApiModelProperty("是否拍照")
  @Column(name = "photograph", columnDefinition = "int COMMENT '是否拍照'")
  private Boolean photograph = false;

  /**
   * 签收资源名称
   */
  @Column(name = "sign_resource_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 签收资源名称 '")
  @ApiModelProperty("签收资源名称")
  @TableField(value = "sign_resource_name")
  private String signResourceName;

  /**
   * 活动签收任务明细表
   */
  @ApiModelProperty("活动签收任务明细表")
  @TableField(exist = false)
  private List<SignTaskActivityDetail> signTaskActivityDetails;

  /**
   * 活动签收任务照片表
   */
  @ApiModelProperty("活动签收任务照片表")
  @TableField(exist = false)
  private List<SignTaskActivityPicture> signTaskActivityPictures;

}
