package com.biz.crm.cps.business.signtask.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.math.BigDecimal;


/**
 * @description: 活动签收任务明细表
 * @author: rentao
 * @date: 2021/12/23 14:49
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SignTaskActivityDetail", description = "活动签收任务明细表")
@TableName("sign_task_activity_detail")
public class SignTaskActivityDetail extends BaseIdEntity {

  private static final long serialVersionUID = -2907621585607605964L;

  /**
   * 签收任务编码
   */
  @Column(name = "sign_task_activity_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 签收任务编码 '")
  @ApiModelProperty("签收任务编码")
  @TableField(value = "sign_task_activity_code")
  private String signTaskActivityCode;

  /**
   * 签收资源编码
   */
  @Column(name = "sign_resource_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 签收资源编码 '")
  @ApiModelProperty("签收资源编码")
  @TableField(value = "sign_resource_code")
  private String signResourceCode;

  /**
   * 签收资源名称
   */
  @Column(name = "sign_resource_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 签收资源名称 '")
  @ApiModelProperty("签收资源名称")
  @TableField(value = "sign_resource_name")
  private String signResourceName;

  /**
   * 签收资源图片
   */
  @Column(name = "url_path",  columnDefinition = "VARCHAR(255) COMMENT ' 签收资源图片 '")
  @ApiModelProperty("签收资源图片")
  @TableField(value = "url_path")
  private String urlPath;

  /**
   * 销售单位
   */
  @ApiModelProperty("销售单位")
  @Column(name = "sale_unit",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 销售单位 '")
  @TableField(value = "sale_unit")
  private String saleUnit;

  /**
   * 签收数量
   */
  @Column(name = "quantity", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' quantity '")
  @ApiModelProperty("签收数量")
  @TableField(value = "quantity")
  private BigDecimal quantity;

}
