package com.biz.crm.cps.business.signtask.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * @description: 活动签收任务照片表
 * @author: rentao
 * @date: 2021/12/23 14:52
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SignTaskActivityPicture", description = "活动签收任务照片表")
@TableName("sign_task_activity_picture")
public class SignTaskActivityPicture extends BaseIdEntity {


  private static final long serialVersionUID = -2907621585607605964L;

  /**
   * 签收任务编码
   */
  @Column(name = "sign_task_activity_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT ' 签收任务编码 '")
  @ApiModelProperty("签收任务编码")
  @TableField(value = "sign_task_activity_code")
  private String signTaskActivityCode;

  /**
   * 文件名
   */
  @ApiModelProperty(name = "fileName", value = "文件名", required = true)
  @Column(name = "file_name", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '文件名'")
  @TableField(value = "file_name")
  private String fileName;

  /**
   * 文件唯一标识
   */
  @ApiModelProperty(name = "objectName", value = "文件唯一标识", required = true)
  @Column(name = "object_name", length = 200, columnDefinition = "VARCHAR(200)  COMMENT '文件唯一标识'")
  @TableField(value = "object_name")
  private String objectName;

  /**
   * 文件全路径
   */
  @ApiModelProperty(name = "url", value = "文件全路径", required = true)
  @Column(name = "url", length = 200, columnDefinition = "VARCHAR(200) NOT NULL COMMENT '文件全路径'")
  @TableField(value = "url")
  private String url;

  /**
   * 文件路径
   */
  @ApiModelProperty(name = "urlPath", value = "文件路径", required = true)
  @Column(name = "url_path", length = 200, columnDefinition = "VARCHAR(200)  COMMENT '文件路径'")
  @TableField(value = "url_path")
  private String urlPath;

  /**
   * 域名
   */
  @ApiModelProperty(name = "urlPathPrefix", value = "域名", required = true)
  @Column(name = "url_path_prefix", length = 128, columnDefinition = "VARCHAR(128) COMMENT '域名'")
  @TableField(value = "url_path_prefix")
  private String urlPathPrefix;

  /**
   * 照片顺序
   * */
  @ApiModelProperty("照片顺序")
  @TableField(value = "index_code")
  @Column(name = "index_code", length = 10, nullable = false,columnDefinition = "int(10) NOT NULL COMMENT '照片顺序'")
  private Integer indexCode;
}
