package com.biz.crm.cps.business.signtask.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * @description: 签收活动与指定客户关联表
 * @author: rentao
 * @date: 2021/12/22 15:04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SignTaskCusRelationship", description = "签收活动与指定客户关联表")
@TableName("sign_task_cus_relationship")
public class SignTaskCusRelationship extends BaseIdEntity {

  /**
   * 签收活动编码
   */
  @Column(name = "sign_task_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 签收活动编码 '")
  @ApiModelProperty("签收活动编码")
  @TableField(value = "sign_task_code")
  private String signTaskCode;

  /**
   * 指定客户编码
   */
  @Column(name = "customer_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 指定客户编码 '")
  @ApiModelProperty("指定客户编码")
  @TableField(value = "customer_code")
  private String customerCode;

  /**
   * 指定客户
   */
  @Column(name = "customer_name",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 指定客户 '")
  @ApiModelProperty("指定客户")
  @TableField(value = "customer_name")
  private String customerName;

  /**
   * 指定客户组织
   */
  @Column(name = "customer_org_name",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 指定客户组织 '")
  @ApiModelProperty("指定客户组织")
  @TableField(value = "customer_org_name")
  private String customerOrgName;

  /**
   * 指定客户组织编码
   */
  @Column(name = "customer_org_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 指定客户组织编码 '")
  @ApiModelProperty("指定客户组织编码")
  @TableField(value = "customer_org_code")
  private String customerOrgCode;

  /**
   * 指定客户类型
   */
  @Column(name = "customer_type", columnDefinition = "VARCHAR(64) COMMENT ' 指定客户类型 '")
  @ApiModelProperty("指定客户类型")
  @TableField(value = "customer_type")
  private String customerType;

  /**
   * 所属组织编码
   */
  @Column(name = "org_code", columnDefinition = "VARCHAR(64) COMMENT ' 所属组织编码 '")
  @ApiModelProperty("所属组织编码")
  @TableField(value = "org_code")
  private String orgCode;

  /**
   * 所属组织
   */
  @Column(name = "org_name", columnDefinition = "VARCHAR(64) COMMENT ' 所属组织 '")
  @ApiModelProperty("所属组织")
  @TableField(value = "org_name")
  private String orgName;

  /**
   * 所属渠道
   */
  @Column(name = "channel_code", columnDefinition = "VARCHAR(64) COMMENT ' 所属渠道 '")
  @ApiModelProperty("所属渠道")
  @TableField(value = "channel_code")
  private String channelCode;

  /**
   * 所属渠道名称
   */
  @Column(name = "channel_name", columnDefinition = "VARCHAR(64) COMMENT ' 所属渠道名称 '")
  @ApiModelProperty("所属渠道名称")
  @TableField(value = "channel_name")
  private String channelName;


}
