package com.biz.crm.cps.business.signtask.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.signtask.local.entity.SignTask;
import com.biz.crm.cps.business.signtask.sdk.dto.SignTaskDto;
import org.apache.ibatis.annotations.Param;

/**
 * @description: 活动签约配置 相关mybatis操作
 * @author: rentao
 * @date: 2021/12/20 19:03
 */
public interface SignTaskMapper extends BaseMapper<SignTask> {

  /**
   * 根据主键查询分利模板详细信息（包括关联表）
   * @param id 主键id
   * @return 活动签约配置实体信息
   */
  SignTask findById(@Param("id") String id);

  /**
   * 分页查询
   * @param page 分页参数
   * @param dto dto
   * @return 返回列表
   */
  Page<SignTask> findByConditions(Page<SignTask> page, @Param("dto") SignTaskDto dto);
}
