package com.biz.crm.cps.business.signtask.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.signtask.local.entity.SignTask;
import com.biz.crm.cps.business.signtask.local.entity.SignTaskActivity;
import com.biz.crm.cps.business.signtask.local.mapper.SignTaskActivityMapper;
import com.biz.crm.cps.business.signtask.sdk.dto.SignTaskActivityDto;
import com.biz.crm.cps.business.signtask.sdk.enums.SignTaskStatusEnum;
import java.util.Date;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * @description: 活动签收任务  Repository
 * @author: rentao
 * @date: 2021/12/23 18:34
 */
@Component
public class SignTaskActivityRepository extends
    ServiceImpl<SignTaskActivityMapper, SignTaskActivity> {

  /**
   * 分页查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  public Page<SignTaskActivity> findByConditions(Pageable pageable, SignTaskActivityDto dto) {
    Page<SignTaskActivity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, dto);
  }

  /**
   * 根据主键查询活动签约任务结束时间查询 小于等于传入时间的未签约数据
   *
   * @param signTaskEndTime 结束时间
   * @return 活动签约任务实体信息
   */
  public List<SignTaskActivity> findBySignTaskEndTime(Date signTaskEndTime) {
    return this.lambdaQuery().le(SignTaskActivity::getSignTaskEndTime, signTaskEndTime)
        .eq(SignTaskActivity::getSignTaskStatus, SignTaskStatusEnum.STATUS_WAIT.getKey()).list();
  }

  /**
   * 根据签约配置编码查询活动签约任务
   *
   * @param signTaskCodes
   * @return 活动签约任务实体信息
   */
  public List<SignTaskActivity> findBySignTaskCodes(List<String> signTaskCodes) {
    return this.lambdaQuery().in(SignTaskActivity::getSignTaskCode, signTaskCodes)
        .list();
  }

  /**
   * 批量启用-禁用
   *
   * @param enable 启用或禁用
   * @param ids    操作主键集合
   */
  public void updateEnableStatusByIds(EnableStatusEnum enable, List<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return;
    }
    this.lambdaUpdate().set(SignTaskActivity::getEnableStatus, enable.getCode())
        .in(SignTaskActivity::getId, ids).update();
  }

}
