package com.biz.crm.cps.business.signtask.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.signtask.local.entity.SignTaskCusRelationship;
import com.biz.crm.cps.business.signtask.local.entity.SignTaskCusRelationship;
import com.biz.crm.cps.business.signtask.local.entity.SignTaskTerminalRelationship;
import com.biz.crm.cps.business.signtask.local.mapper.SignTaskCusRelationshipMapper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

/**
 * @description: 活动签约配置关联客户
 * @author: rentao
 * @date: 2021/12/22 15:14
 */
@Component
public class SignTaskCusRelationshipRepository  extends
    ServiceImpl<SignTaskCusRelationshipMapper, SignTaskCusRelationship> {

  /**
   * 根据活动签约编码编码删除关联信息
   * @param signTaskCode
   */
  public void deleteBySignTaskCode(String signTaskCode) {
    this.lambdaUpdate().eq(SignTaskCusRelationship::getSignTaskCode, signTaskCode).remove();
  }

  /**
   * 根据活动签约编码查询关联信息
   * @param signTaskCode
   */
  public List<SignTaskCusRelationship> findBySignTaskCode(String signTaskCode){
    return this.lambdaQuery()
        .eq(SignTaskCusRelationship::getSignTaskCode, signTaskCode).list();
  }
}
