package com.biz.crm.cps.business.signtask.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.signtask.local.entity.SignTaskMaterialRelationship;
import com.biz.crm.cps.business.signtask.local.entity.SignTaskOrgRelationship;
import com.biz.crm.cps.business.signtask.local.mapper.SignTaskMaterialRelationshipMapper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

/**
 * @description: 活动签约配置关联物料
 * @author: rentao
 * @date: 2021/12/21 10:46
 */
@Component
public class SignTaskMaterialRelationshipRepository extends
    ServiceImpl<SignTaskMaterialRelationshipMapper, SignTaskMaterialRelationship> {

  /**
   * 根据活动签约编码删除关联信息
   * @param signTaskCode
   */
  public void deleteBySignTaskCode(String signTaskCode) {
    this.lambdaUpdate().eq(SignTaskMaterialRelationship::getSignTaskCode, signTaskCode).remove();
  }

  /**
   * 根据活动签约编码查询关联信息
   * @param signTaskCode
   */
  public List<SignTaskMaterialRelationship> findBySignTaskCode(String signTaskCode){
    return this.lambdaQuery()
        .eq(SignTaskMaterialRelationship::getSignTaskCode, signTaskCode).list();
  }
}
