package com.biz.crm.cps.business.signtask.local.repository;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.signtask.local.entity.SignTask;
import com.biz.crm.cps.business.signtask.local.mapper.SignTaskMapper;
import com.biz.crm.cps.business.signtask.sdk.dto.SignTaskDto;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * @description: 活动签约配置
 * @author: rentao
 * @date: 2021/12/20 19:02
 */
@Component
public class SignTaskRepository extends
    ServiceImpl<SignTaskMapper, SignTask> {

  /**
   * 分页查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  public Page<SignTask> findByConditions(Pageable pageable, SignTaskDto dto) {
    Page<SignTask> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, dto);
  }

  /**
   * 根据主键查询活动签约配置详细信息（包括关联表）
   *
   * @param id 主键id
   * @return 活动签约配置实体信息
   */
  public SignTask findById(String id) {
    return this.baseMapper.findById(id);
  }

  /**
   * 批量启用-禁用
   *
   * @param enable 启用或禁用
   * @param ids    操作主键集合
   */
  public void updateEnableStatusByIds(EnableStatusEnum enable, List<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return;
    }
    this.lambdaUpdate().set(SignTask::getEnableStatus, enable.getCode())
        .in(SignTask::getId, ids).update();
  }
}
