package com.biz.crm.cps.business.signtask.local.service.notifier;

import com.biz.crm.cps.business.agreement.sdk.dto.ProfitAgreementTemplatePaginationDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementTemplateVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementTemplateVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.participator.sdk.service.DealerVoService;
import com.biz.crm.cps.business.participator.sdk.service.TerminalVoService;
import com.biz.crm.cps.business.participator.sdk.vo.DealerVo;
import com.biz.crm.cps.business.participator.sdk.vo.TerminalVo;
import com.biz.crm.cps.business.reward.gift.sdk.event.RewardGiftDetailEventListener;
import com.biz.crm.cps.business.reward.gift.sdk.vo.RewardGiftDetailVo;
import com.biz.crm.cps.business.signtask.local.config.SignTaskConfig;
import com.biz.crm.cps.business.signtask.local.entity.SignTaskActivity;
import com.biz.crm.cps.business.signtask.local.entity.SignTaskActivityDetail;
import com.biz.crm.cps.business.signtask.local.service.SignTaskActivityService;
import com.biz.crm.cps.business.signtask.sdk.enums.SignTaskActivityTypeEnum;
import com.biz.crm.cps.business.signtask.sdk.enums.SignTaskStatusEnum;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * @description: 赠品 创建 活动签约任务
 * @author: rentao
 * @date: 2021/12/26 13:21
 */
@Service
@Slf4j
public class RewardGiftDetailEventListenerImpl implements RewardGiftDetailEventListener {

  @Autowired
  private SignTaskActivityService signTaskActivityService;
  @Autowired
  private TerminalVoService terminalVoService;
  @Autowired
  private DealerVoService dealerVoService;
  @Autowired
  private AgreementTemplateVoService agreementTemplateVoService;
  @Autowired
  private SignTaskConfig signTaskConfig;

  private static final String SALE_UNIT = "元";

  @Override
  @Transactional
  public void onRequestCreateSignTaskActivity(RewardGiftDetailVo rewardGiftDetailVo) {
    Validate.notNull(rewardGiftDetailVo, "奖励赠品流水为空");
    if (Objects.isNull(ParticipatorTypeEnum.getByKey(rewardGiftDetailVo.getParticipatorType()))) {
      return;
    }
    SignTaskActivity signTaskActivity = new SignTaskActivity();
    if (ParticipatorTypeEnum.CONSUMER.getKey().equals(rewardGiftDetailVo.getParticipatorType())) {
      return;
    }
    if (StringUtils.isBlank(rewardGiftDetailVo.getTemplateCode())) {
      return;
    }
    ProfitAgreementTemplatePaginationDto paginationDto = new ProfitAgreementTemplatePaginationDto();
    List<AgreementTemplateVo> agreementTemplateVos = agreementTemplateVoService
        .findByConditions(paginationDto);
    if (CollectionUtils.isEmpty(agreementTemplateVos)) {
      return;
    }
    AgreementTemplateVo agreementTemplateVo = agreementTemplateVos.get(0);
    this.buildSignTaskActivity(signTaskActivity,agreementTemplateVo,rewardGiftDetailVo);
    signTaskActivityService.createBatch(Collections.singletonList(signTaskActivity));
  }

  /**
   *
   * 数据转换
   * @param signTaskActivity
   * @param agreementTemplateVo
   * @param rewardGiftDetailVo
   * @author rentao
   * @date
   */
  private void buildSignTaskActivity(SignTaskActivity signTaskActivity,
      AgreementTemplateVo agreementTemplateVo, RewardGiftDetailVo rewardGiftDetailVo) {
    signTaskActivity.setSignTaskEndTime(agreementTemplateVo.getEffectiveEndTime());
    signTaskActivity.setSignTaskStartTime(agreementTemplateVo.getEffectiveStartTime());
    signTaskActivity.setClientClassify(Integer.valueOf(rewardGiftDetailVo.getParticipatorType()));
    signTaskActivity.setSignTaskActivityType(SignTaskActivityTypeEnum.AGREEMENT_TEMPLATE.getKey());
    signTaskActivity.setSignTaskCode(agreementTemplateVo.getTemplateCode());
    //是否拍照
    signTaskActivity.setPhotograph(true);
    signTaskActivity.setSignTaskName(agreementTemplateVo.getTemplateName());
    signTaskActivity.setSignTaskStatus(SignTaskStatusEnum.STATUS_WAIT.getKey());
    if (ParticipatorTypeEnum.DEALER.getKey().equals(rewardGiftDetailVo.getParticipatorType())) {
       this.buildDealerSignTaskActivity(signTaskActivity,rewardGiftDetailVo);
    } else {
       this.buildTerminalSignTaskActivity(signTaskActivity,rewardGiftDetailVo);
    }
    SignTaskActivityDetail signTaskActivityDetail = new SignTaskActivityDetail();
    signTaskActivityDetail.setQuantity(rewardGiftDetailVo.getAmount());
    signTaskActivityDetail.setSaleUnit(SALE_UNIT);
    signTaskActivityDetail.setUrlPath(signTaskConfig.getImgUrl());
    signTaskActivityDetail.setSignResourceCode(rewardGiftDetailVo.getMaterialCode());
    signTaskActivityDetail.setSignResourceName(rewardGiftDetailVo.getMaterialName());
    signTaskActivity.setSignTaskActivityDetails(Collections.singletonList(signTaskActivityDetail));
  }

  /**
   *
   * 客户部分数据转换
   * @param signTaskActivity
   * @param rewardGiftDetailVo
   * @author rentao
   * @date
   */
  private void buildDealerSignTaskActivity(SignTaskActivity signTaskActivity,
      RewardGiftDetailVo rewardGiftDetailVo) {
    DealerVo dealerVo = dealerVoService
        .findByCustomerCode(rewardGiftDetailVo.getParticipatorCode());
    if(Objects.isNull(dealerVo)){
      return;
    }
    signTaskActivity.setClientOrgCode(dealerVo.getCustomerOrgCode());
    signTaskActivity.setClientOrgName(dealerVo.getCustomerOrgName());
    signTaskActivity.setOrgCode(dealerVo.getOrgCode());
    signTaskActivity.setOrgName(dealerVo.getOrgName());
    signTaskActivity.setChannelCode(dealerVo.getChannelCode());
    signTaskActivity.setChannelName(dealerVo.getChannelName());
    signTaskActivity.setClientType(dealerVo.getCustomerType());
    signTaskActivity.setTagName(dealerVo.getTagDescription());
    signTaskActivity.setSignTaskStatus(SignTaskStatusEnum.STATUS_WAIT.getKey());
  }

  /**
   *
   * 终端部分数据转换
   * @param signTaskActivity
   * @param rewardGiftDetailVo
   * @author rentao
   * @date
   */
  private void buildTerminalSignTaskActivity(SignTaskActivity signTaskActivity,
      RewardGiftDetailVo rewardGiftDetailVo) {
    List<TerminalVo> terminalVos = terminalVoService.findByTerminalCodes(
        Collections.singletonList(rewardGiftDetailVo.getParticipatorCode()));
    if(CollectionUtils.isEmpty(terminalVos)){
      return;
    }
    TerminalVo terminalVo = terminalVos.get(0);
    signTaskActivity.setClientOrgCode(terminalVo.getCustomerOrganizationCode());
    signTaskActivity.setClientOrgName(terminalVo.getCustomerOrganization());
    signTaskActivity.setOrgCode(terminalVo.getOrganizationCode());
    signTaskActivity.setOrgName(terminalVo.getOrganization());
    signTaskActivity.setChannelCode(terminalVo.getChannel());
    signTaskActivity.setChannelName(terminalVo.getChannelName());
    signTaskActivity.setClientType(terminalVo.getTerminalType());
    signTaskActivity.setTagName(terminalVo.getTagDescription());
  }
}
