package com.biz.crm.cps.business.signtask.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @description: some desc
 * @author: rentao
 * @date: 2021/12/23 17:30
 */
@Data
@ApiModel(value = "SignTaskDto", description = "签约活动dto")
public class SignTaskActivityDto extends TenantFlagOpVo {

  /**
   * 签收活动编码
   */
  @ApiModelProperty("签收活动编码")
  private String signTaskCode;

  /**
   * 签收活动名称
   */
  @ApiModelProperty("签收活动名称")
  private String signTaskName;

  /**
   * 签收活动名称
   */
  @ApiModelProperty("签收活动名称")
  private String signTaskActivityCode;

  /**
   * 关联活动类型 0 签约活动 1 协议模板
   */
  @ApiModelProperty("关联活动类型")
  private Integer signTaskActivityType;

  /**
   * 组织名称
   */
  @ApiModelProperty("组织名称")
  private String orgName;

  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 客户所属组织名称
   */
  @ApiModelProperty("客户所属组织名称")
  private String clientOrgName;

  /**
   * 客户所属组织编码
   */
  @ApiModelProperty("客户所属组织编码")
  private String clientOrgCode;

  /**
   * 渠道编码
   */
  @ApiModelProperty("渠道编码")
  private String channelCode;

  /**
   * 渠道名称
   */
  @ApiModelProperty("渠道名称")
  private String channelName;

  /**
   * 客户分类 0经销商 ,1终端
   */
  @ApiModelProperty("客户分类 0经销商 1终端")
  private Integer clientClassify;

  /**
   * 经销商/终端类型
   */
  @ApiModelProperty(" 经销商/终端类型")
  private String clientType;

  /**
   * 标签名称
   */
  @ApiModelProperty(" 标签名称")
  private String tagName;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String clientCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String clientName;

  /**
   * 签收状态：0 未签收；1已签收 2 已过期
   */
  @ApiModelProperty("签收状态：0 未签收；1已签收 2 已过期 ")
  private Integer signTaskStatus;

  /**
   * 签收有效期开始日期
   */
  @ApiModelProperty("签收有效期开始日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date signTaskStartTime;

  /**
   * 签收有效期结束日期
   */
  @ApiModelProperty("签收有效期开始日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date signTaskEndTime;

  /**
   * 查询标记: H5/ADMIN
   */
  @ApiModelProperty("查询标记: H5/ADMIN")
  private String queryFlag;

}
