package com.biz.crm.cps.business.signtask.sdk.dto;


import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @description: 签约dto
 * @author: rentao
 * @date: 2021/12/21 11:20
 */
@Data
@ApiModel(value = "SignTaskDto", description = "签约dto")
public class SignTaskDto {
  /**
   * 权限类型
   */
  @ApiModelProperty("权限类型：0全部终端门店，1部分终端门店，2指定终端门店")
  private Integer permissionType;

  /**
   * 活动类型：0实物；1现金
   * */
  @ApiModelProperty("活动类型：0实物；1现金")
  private Integer signTaskType;

  /**
   * 签约客户类型 0 经销商  1 终端
   */
  @ApiModelProperty("签约客户类型 0 经销商  1 终端")
  private Integer signType;

  /**
   * 是否拍照
   */
  @ApiModelProperty("是否拍照")
  private Boolean photograph;

  /**
   * 签收活动编码
   */
  @ApiModelProperty("签收活动编码")
  private String signTaskCode;

  /**
   * 签收活动名称
   */
  @ApiModelProperty("签收活动名称")
  private String signTaskName;

  /**
   * 签收有效期开始日期
   */
  @ApiModelProperty("签收有效期开始日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date signTaskStartTime;

  /**
   * 签收有效期结束日期
   */
  @ApiModelProperty("签收有效期结束日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date signTaskEndTime;

  /**
   * 租户编号
   *  @Column(name = "tenant_code", nullable = false, columnDefinition = "varchar(64) COMMENT '租户编号'")
   */
  @ApiModelProperty(name = "tenantCode", value = "租户编号", required = true)
  private String tenantCode;

  /**
   * 删除标识
   * */
  @ApiModelProperty(value = "删除标识")
  private String delFlag;

  /**
   * 启用状态
   * */
  @ApiModelProperty(value = "启用状态")
  private String enableStatus;

}
