package com.biz.crm.cps.business.signtask.sdk.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @description: 权限类型
 * @author: rentao
 * @date: 2021/12/22 10:45
 */
public enum PermissionTypeEnum {

  ALL_TERMINAL (0,"0", "全部终端门店","1"),
  PARTIAL_TERMINAL(1,"1", "部分终端门店","2"),
  APPOINT_TERMINAL(2, "2","指定终端门店","3");
  /**
   * 系统key
   */
  private Integer key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  PermissionTypeEnum(Integer key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public Integer getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }
  /**
   * 通过key获取 PermissionTypeEnum
   *
   * @param key
   * @return
   */
  public static PermissionTypeEnum getByKey(Integer key) {
    return Arrays.stream(PermissionTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), key))
        .findFirst().orElse(null);
  }
  /**
   * 通过dictCode获取 PermissionTypeEnum
   *
   * @param dictCode
   * @return
   */
  public static PermissionTypeEnum getByDictCode(String dictCode) {
    return Arrays.stream(PermissionTypeEnum.values()).filter(item -> Objects.equals(item.getDictCode(), dictCode))
        .findFirst().orElse(null);
  }
}
