package com.biz.crm.cps.business.signtask.sdk.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @description: 关联活动类型
 * @author: rentao
 * @date: 2021/12/28 10:34
 */
public enum SignTaskActivityTypeEnum {

  /**
   * 签约活动
   */
  SIGN_ACTIVITY(0,"0", "签约活动","1"),

  /**
   * 协议模板
   */
  AGREEMENT_TEMPLATE(1,"1", "协议模板","2");


  private Integer key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  SignTaskActivityTypeEnum(Integer key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public Integer getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }
  /**
   * 通过key获取 SignTaskActivityTypeEnum
   *
   * @param key
   * @return
   */
  public static SignTaskActivityTypeEnum getByKey(Integer key) {
    return Arrays
        .stream(SignTaskActivityTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), key))
        .findFirst().orElse(null);
  }
  /**
   * 通过dictCode获取 SignTaskActivityTypeEnum
   *
   * @param dictCode
   * @return
   */
  public static SignTaskActivityTypeEnum getByDictCode(String dictCode) {
    return Arrays.stream(SignTaskActivityTypeEnum.values()).filter(item -> Objects.equals(item.getDictCode(), dictCode))
        .findFirst().orElse(null);
  }
}
