package com.biz.crm.cps.business.signtask.sdk.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @description: some desc
 * @author: rentao
 * @date: 2021/12/26 11:39
 */
public enum SignTaskStatusEnum {

  /**
   * 未开始
   */
  STATUS_WAIT(0,"0", "待签约","1"),

  /**
   * 已完成
   */
  STATUS_COMPLETE(1,"1", "已签约","2"),

  /**
   * 已过期
   */
  STATUS_EXPIRED(2,"2", "已过期","3");

  private Integer key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  SignTaskStatusEnum(Integer key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public Integer getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }
  /**
   * 通过key获取 SignTaskTypeEnum
   *
   * @param key
   * @return
   */
  public static SignTaskStatusEnum getByKey(Integer key) {
    return Arrays
        .stream(SignTaskStatusEnum.values()).filter(item -> Objects.equals(item.getKey(), key))
        .findFirst().orElse(null);
  }
  /**
   * 通过dictCode获取 SignTaskTypeEnum
   *
   * @param dictCode
   * @return
   */
  public static SignTaskStatusEnum getByDictCode(String dictCode) {
    return Arrays.stream(SignTaskStatusEnum.values()).filter(item -> Objects.equals(item.getDictCode(), dictCode))
        .findFirst().orElse(null);
  }
}
