package com.biz.crm.cps.business.signtask.sdk.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @description: 活动类型枚举
 * @author: rentao
 * @date: 2021/12/22 10:33
 */
public enum  SignTaskTypeEnum {

  MATTER(1,"1", "实物","1"),
  CASH(2, "2","现金","2");

  private Integer key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  SignTaskTypeEnum(Integer key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public Integer getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }
  /**
   * 通过key获取 SignTaskTypeEnum
   *
   * @param key
   * @return
   */
  public static SignTaskTypeEnum getByKey(Integer key) {
    return Arrays
        .stream(SignTaskTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), key))
        .findFirst().orElse(null);
  }
  /**
   * 通过dictCode获取 SignTaskTypeEnum
   *
   * @param dictCode
   * @return
   */
  public static SignTaskTypeEnum getByDictCode(String dictCode) {
    return Arrays.stream(SignTaskTypeEnum.values()).filter(item -> Objects.equals(item.getDictCode(), dictCode))
        .findFirst().orElse(null);
  }
}
