package com.biz.crm.cps.business.signtask.sdk.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @description: 签约类型
 * @author: rentao
 * @date: 2021/12/22 14:58
 */
public enum SignTypeEnum {

  CUS (0,"0", "客户","1"),
  TERMINAL(1,"1", "终端","2");

  private Integer key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  SignTypeEnum(Integer key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public Integer getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }
  /**
   * 通过key获取 SignTypeEnum
   *
   * @param key
   * @return
   */
  public static SignTypeEnum getByKey(Integer key) {
    return Arrays
        .stream(SignTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), key))
        .findFirst().orElse(null);
  }
  /**
   * 通过dictCode获取 SignTypeEnum
   *
   * @param dictCode
   * @return
   */
  public static SignTypeEnum getByDictCode(String dictCode) {
    return Arrays.stream(SignTypeEnum.values()).filter(item -> Objects.equals(item.getDictCode(), dictCode))
        .findFirst().orElse(null);
  }
}
