package com.biz.crm.cps.business.signtask.sdk.event;

import com.biz.crm.cps.business.signtask.sdk.vo.SignTaskVo;
import java.util.List;

/**
 * @description: 客户签约通知
 * @author: rentao
 * @date: 2021/12/22 15:29
 */
public interface SignTaskEventListener {

  /**
   * 启用时触发事件
   * @param signTaskVos
   * @return
   */
  void onDisable(List<SignTaskVo> signTaskVos);

  /**
   * 停用时触发事件
   * @param signTaskVos
   * @return
   */
  void onEnable(List<SignTaskVo> signTaskVos);

  /**
   * 编辑时触发事件
   * @param signTaskVo
   * @return
   */
  void onUpdate(SignTaskVo signTaskVo);

  /**
   * 创建时触发事件
   * @param signTaskVo
   * @return
   */
  void onCreate(SignTaskVo signTaskVo);
}
