package com.biz.crm.cps.business.signtask.sdk.vo;

import com.biz.crm.cps.business.common.sdk.vo.BaseIdVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * @description: 签收活动与客户关联vo
 * @author: rentao
 * @date: 2021/12/22 15:34
 */
@Getter
@Setter
@ApiModel(value = "SignTaskCusRelationshipVo", description = "签收活动与客户关联vo")
public class SignTaskCusRelationshipVo extends BaseIdVo {
  /**
   * 签收活动编码
   */
  @ApiModelProperty("签收活动编码")
  private String signTaskCode;

  /**
   * 指定客户编码
   */
  @ApiModelProperty("指定客户编码")
  private String customerCode;

  /**
   * 指定客户
   */
  @ApiModelProperty("指定客户")
  private String customerName;

  /**
   * 指定客户组织
   */
  @ApiModelProperty("指定客户组织")
  private String customerOrgName;

  /**
   * 指定客户组织编码
   */
  @ApiModelProperty("指定客户组织编码")
  private String customerOrgCode;

  /**
   * 指定客户类型
   */
  @ApiModelProperty("指定客户类型")
  private String customerType;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  private String orgCode;

  /**
   * 所属组织
   */
  @ApiModelProperty("所属组织")
  private String orgName;

  /**
   * 所属渠道
   */
  @ApiModelProperty("所属渠道")
  private String channelCode;

  /**
   * 所属渠道名称
   */
  @ApiModelProperty("所属渠道名称")
  private String channelName;

}
