package com.biz.crm.cps.business.signtask.sdk.vo;

import com.biz.crm.cps.business.common.sdk.vo.BaseIdVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @description: 签收活动与物料关联vo
 * @author: rentao
 * @date: 2021/12/22 15:34
 */
@Getter
@Setter
@ApiModel(value = "SignTaskMaterialRelationshipVo", description = "签收活动与物料关联vo")
public class SignTaskMaterialRelationshipVo extends BaseIdVo {

  /**
   * 签收活动编码
   */
  @ApiModelProperty("签收活动编码")
  private String signTaskCode;

  /**
   * 物料编码
   */
  @ApiModelProperty("物料编码")
  private String materialCode;

  /**
   * 物料名称
   */
  @ApiModelProperty("物料名称")
  private String materialName;

  /**
   * 物料类型
   */
  @ApiModelProperty("物料类型")
  private String materialType;

  /**
   * 商品图片
   */
  @ApiModelProperty("商品图片")
  private String imgUrl;

  /**
   * 销售单位
   */
  @ApiModelProperty("销售单位")
  private String saleUnit;

  /**
   * 数量
   */
  @ApiModelProperty("数量")
  private BigDecimal quantity;
}
