package com.biz.crm.cps.business.signtask.sdk.vo;

import com.biz.crm.cps.business.common.sdk.vo.BaseIdVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * @description: 签收活动与终端关联vo
 * @author: rentao
 * @date: 2021/12/22 15:34
 */
@Getter
@Setter
@ApiModel(value = "SignTaskTerminalRelationshipVo", description = "签收活动与终端关联vo")
public class SignTaskTerminalRelationshipVo extends BaseIdVo {
  /**
   * 签收活动编码
   */
  @ApiModelProperty("签收活动编码")
  private String signTaskCode;

  /**
   * 指定终端编码
   */
  @ApiModelProperty("指定终端编码")
  private String terminalCode;

  /**
   * 指定终端编码
   */
  @ApiModelProperty("指定终端名称")
  private String terminalName;

  /**
   * 指定终端标签
   */
  @ApiModelProperty("指定终端标签")
  private String tagDescription;

  /**
   * 指定终端类型
   */
  @ApiModelProperty("指定终端类型")
  private String terminalType;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  private String organizationCode;

  /**
   * 所属组织
   */
  @ApiModelProperty("所属组织")
  private String organization;

  /**
   * 所属客户组织
   */
  @ApiModelProperty("所属客户组织")
  private String customerOrganization;

  /**
   * 所属客户组织编码
   */
  @ApiModelProperty("所属客户组织编码")
  private String customerOrganizationCode;

  /**
   * 所属渠道
   */
  @ApiModelProperty("所属渠道")
  private String channelCode;

  /**
   * 所属渠道名称
   */
  @ApiModelProperty("所属渠道名称")
  private String channelName;
}
