package com.biz.crm.cps.business.signtask.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.business.common.sdk.vo.TenantOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @description: 客户签约vo
 * @author: rentao
 * @date: 2021/12/22 15:31
 */
@Getter
@Setter
@ApiModel(value = "SignTaskVo", description = "客户签约vo")
public class SignTaskVo extends TenantFlagOpVo {
  private static final long serialVersionUID = 4152275804637321581L;

  /**
   * 签收活动编码
   */
  @ApiModelProperty("签收活动编码")
  private String signTaskCode;

  /**
   * 签收活动名称
   */
  @ApiModelProperty("签收活动名称")
  private String signTaskName;

  /**
   * 签收金额
   */
  @ApiModelProperty("签收金额")
  private BigDecimal signTaskAmount;

  /**
   * 是否拍照
   */
  @ApiModelProperty("是否拍照")
  private Boolean photograph = false;

  /**
   * 签收有效期开始日期
   */
  @ApiModelProperty("签收有效期开始日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date signTaskStartTime;

  /**
   * 签收有效期结束日期
   */
  @ApiModelProperty("签收有效期结束日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date signTaskEndTime;

  /**
   * 权限类型
   */
  @ApiModelProperty("权限类型：0全部终端门店，1部分终端门店，2指定终端门店")
  private Integer permissionType;

  /**
   * 活动类型：0实物；1现金
   * */
  @ApiModelProperty("活动类型：0实物；1现金")
  private Integer signTaskType;

  /**
   * 签收状态：flase 未签收；true已签收
   * */
  @ApiModelProperty("签收状态：flase 未签收；true已签收  ")
  private Boolean signTaskStatus;

  /**
   * 签约客户类型 0 经销商  1 终端
   */
  @ApiModelProperty("签约客户类型 0 经销商  1 终端")
  private Integer signType;

  /**
   * 关联标签
   */
  @ApiModelProperty("关联标签")
  private Set<SignTaskTagRelationshipVo> signTaskTagRelationships;

  /**
   * 关联渠道
   */
  @ApiModelProperty("关联渠道")
  private Set<SignTaskChannelRelationshipVo> signTaskChannelRelationships;

  /**
   * 关联所属组织列表
   */
  @ApiModelProperty("关联所属组织列表")
  private Set<SignTaskOrgRelationshipVo> signTaskOrgRelationships;

  /**
   * 关联终端门店编码集合
   */
  @ApiModelProperty("关联终端门店编码集合")
  private Set<SignTaskTerminalRelationshipVo> signTaskTerminalRelationships;

  /**
   * 关联客户编码集合
   */
  @ApiModelProperty("关联客户编码集合")
  private Set<SignTaskCusRelationshipVo> signTaskCusRelationships;

  /**
   * 关联物料信息集合
   */
  @ApiModelProperty("关联物料信息集合")
  private Set<SignTaskMaterialRelationshipVo> signTaskMaterialRelationships;
}
