/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.barcode.local.service.internal;

import cn.hutool.core.date.DateUtil;
import com.biz.crm.cps.external.barcode.local.model.ScanCodeRecordReportItemModelVo;
import com.biz.crm.cps.external.barcode.local.repository.ScanCodeRecordRepository;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeReportSearchTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeReportDto;
import com.biz.crm.cps.external.barcode.sdk.service.ScanCodeReportVoService;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeReportVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ScanCodeReportVoServiceImpl
implements ScanCodeReportVoService {
    private static final Logger log = LoggerFactory.getLogger(ScanCodeReportVoServiceImpl.class);
    @Autowired
    private ScanCodeRecordRepository scanCodeRecordRepository;
    private static final String BEGIN = "begin";
    private static final String END = "end";

    public List<ScanCodeReportVo> findByScanCodeReportDto(ScanCodeReportDto dto) {
        LinkedList re = Lists.newLinkedList();
        if (Objects.isNull(dto) || CollectionUtils.isEmpty((Collection)dto.getSearchTypeSet()) || StringUtils.isBlank((CharSequence)dto.getBarCodeParticipatorCode())) {
            return Lists.newLinkedList();
        }
        for (String searchType : dto.getSearchTypeSet()) {
            Map<String, Date> map = this.findBetweenDateMap(searchType);
            List<ScanCodeRecordReportItemModelVo> list = this.scanCodeRecordRepository.findByScanCodeReportDtoAndTime(dto, map.getOrDefault(BEGIN, null), map.getOrDefault(END, null));
            if (CollectionUtils.isEmpty(list)) continue;
            for (ScanCodeRecordReportItemModelVo item : list) {
                ScanCodeReportVo cur = new ScanCodeReportVo();
                cur.setScanType(item.getScanType());
                cur.setSearchType(searchType);
                cur.setBarCodeType(item.getBarCodeType());
                cur.setQuantity(item.getQuantity());
                re.add(cur);
            }
        }
        return re;
    }

    private Map<String, Date> findBetweenDateMap(String searchType) {
        HashMap map = Maps.newHashMap();
        ScanCodeReportSearchTypeEnum typeEnum = ScanCodeReportSearchTypeEnum.findByDictCode((String)searchType);
        if (Objects.isNull(typeEnum)) {
            return map;
        }
        if (typeEnum.equals((Object)ScanCodeReportSearchTypeEnum.ALL)) {
            return map;
        }
        Date now = new Date();
        if (typeEnum.equals((Object)ScanCodeReportSearchTypeEnum.MONTH)) {
            map.put(BEGIN, DateUtil.beginOfMonth((Date)now));
        }
        if (typeEnum.equals((Object)ScanCodeReportSearchTypeEnum.SEASON)) {
            map.put(BEGIN, DateUtil.beginOfQuarter((Date)now));
        }
        if (typeEnum.equals((Object)ScanCodeReportSearchTypeEnum.YEAR)) {
            map.put(BEGIN, DateUtil.beginOfYear((Date)now));
        }
        if (typeEnum.equals((Object)ScanCodeReportSearchTypeEnum.TODAY)) {
            map.put(BEGIN, DateUtil.beginOfDay((Date)now));
        }
        if (typeEnum.equals((Object)ScanCodeReportSearchTypeEnum.YESTERDAY)) {
            map.put(BEGIN, DateUtil.beginOfDay((Date)DateUtil.yesterday()));
            map.put(END, DateUtil.endOfDay((Date)DateUtil.yesterday()));
        }
        if (typeEnum.equals((Object)ScanCodeReportSearchTypeEnum.WEEK)) {
            map.put(BEGIN, DateUtil.beginOfWeek((Date)now));
        }
        return map;
    }
}

