/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.barcode.local.service.internal;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.external.barcode.local.entity.ScanCodeWarning;
import com.biz.crm.cps.external.barcode.local.repository.ScanCodeWarningRepository;
import com.biz.crm.cps.external.barcode.local.service.ScanCodeWarningService;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeWarningTypeEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScanCodeWarningServiceImpl
implements ScanCodeWarningService {
    @Autowired
    private ScanCodeWarningRepository scanCodeWarningRepository;
    @Autowired
    private LoginUserService loginUserService;

    @Override
    public ScanCodeWarning create(ScanCodeWarning scanCodeWarning) {
        Validate.notNull((Object)((Object)scanCodeWarning), (String)"\u521b\u5efa\u626b\u7801\u9884\u8b66\u914d\u7f6e\u65f6\uff0c\u5b9e\u4f53\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)scanCodeWarning.getId()), (String)"\u521b\u5efa\u626b\u7801\u9884\u8b66\u914d\u7f6e\u65f6\uff0c\u4e3b\u952eid\u4e0d\u80fd\u6709\u503c!", (Object[])new Object[0]);
        ScanCodeWarning codeWarning = this.scanCodeWarningRepository.findByTenantCode(TenantUtils.getTenantCode());
        Validate.isTrue((boolean)ObjectUtils.isEmpty((Object)((Object)codeWarning)), (String)"\u6b64\u79df\u6237\u5df2\u7ecf\u521b\u5efa\u8fc7\u626b\u7801\u5f02\u5e38\u9884\u8b66\uff0c\u65e0\u6cd5\u518d\u6b21\u521b\u5efa!", (Object[])new Object[0]);
        this.createValidate(scanCodeWarning);
        scanCodeWarning.setTenantCode(TenantUtils.getTenantCode());
        scanCodeWarning.setCreateAccount(this.loginUserService.getLoginAccountName());
        scanCodeWarning.setCreateTime(new Date());
        this.scanCodeWarningRepository.save((Object)scanCodeWarning);
        return scanCodeWarning;
    }

    @Override
    public ScanCodeWarning update(ScanCodeWarning scanCodeWarning) {
        Validate.notNull((Object)((Object)scanCodeWarning), (String)"\u66f4\u65b0\u626b\u7801\u9884\u8b66\u914d\u7f6e\u65f6\uff0c\u5b9e\u4f53\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeWarning.getId(), (String)"\u66f4\u65b0\u626b\u7801\u9884\u8b66\u914d\u7f6e\u65f6\uff0c\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        this.createValidate(scanCodeWarning);
        scanCodeWarning.setModifyAccount(this.loginUserService.getLoginAccountName());
        scanCodeWarning.setModifyTime(new Date());
        this.scanCodeWarningRepository.updateById((Object)scanCodeWarning);
        return scanCodeWarning;
    }

    @Override
    public ScanCodeWarning findScanCodeWarning() {
        return this.scanCodeWarningRepository.findByTenantCode(TenantUtils.getTenantCode());
    }

    private void createValidate(ScanCodeWarning scanCodeWarning) {
        Validate.notNull((Object)scanCodeWarning.getDealerCrossClientConfig(), (String)"\u8bf7\u8bbe\u7f6e\u7ecf\u9500\u5546-\u8de8\u5ba2\u6237\u626b\u7801\u914d\u7f6e", (Object[])new Object[0]);
        Validate.isTrue((boolean)ScanCodeWarningTypeEnum.contains((String)scanCodeWarning.getDealerCrossClientConfig()), (String)"\u7ecf\u9500\u5546-\u8de8\u5ba2\u6237\u626b\u7801\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeWarning.getTerminalCrossClientConfig(), (String)"\u8bf7\u8bbe\u7f6e\u7ec8\u7aef-\u8de8\u5ba2\u6237\u626b\u7801\u914d\u7f6e", (Object[])new Object[0]);
        Validate.isTrue((boolean)ScanCodeWarningTypeEnum.contains((String)scanCodeWarning.getTerminalCrossClientConfig()), (String)"\u7ec8\u7aef-\u8de8\u5ba2\u6237\u626b\u7801\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeWarning.getTerminalCrossChannelConfig(), (String)"\u8bf7\u8bbe\u7f6e\u7ec8\u7aef-\u8de8\u6e20\u9053\u626b\u7801\u914d\u7f6e", (Object[])new Object[0]);
        Validate.isTrue((boolean)ScanCodeWarningTypeEnum.contains((String)scanCodeWarning.getTerminalCrossChannelConfig()), (String)"\u7ec8\u7aef-\u8de8\u6e20\u9053\u626b\u7801\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeWarning.getNotAssignTerminalConfig(), (String)"\u8bf7\u8bbe\u7f6e\u7ec8\u7aef-\u975e\u6307\u5b9a\u7ec8\u7aef\u914d\u7f6e", (Object[])new Object[0]);
        Validate.isTrue((boolean)ScanCodeWarningTypeEnum.contains((String)scanCodeWarning.getNotAssignTerminalConfig()), (String)"\u7ec8\u7aef-\u975e\u6307\u5b9a\u7ec8\u7aef\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeWarning.getNotAssignSupplyProductConfig(), (String)"\u8bf7\u8bbe\u7f6e\u7ec8\u7aef-\u975e\u6307\u5b9a\u4f9b\u8d27\u4ea7\u54c1\u914d\u7f6e", (Object[])new Object[0]);
        Validate.isTrue((boolean)ScanCodeWarningTypeEnum.contains((String)scanCodeWarning.getNotAssignSupplyProductConfig()), (String)"\u7ec8\u7aef-\u975e\u6307\u5b9a\u4f9b\u8d27\u4ea7\u54c1\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeWarning.getTerminalScanLocationConfig(), (String)"\u8bf7\u8bbe\u7f6e\u7ec8\u7aef-\u626b\u7801\u4f4d\u7f6e\u9884\u8b66\u914d\u7f6e", (Object[])new Object[0]);
        Validate.isTrue((boolean)ScanCodeWarningTypeEnum.contains((String)scanCodeWarning.getTerminalScanLocationConfig()), (String)"\u7ec8\u7aef-\u626b\u7801\u4f4d\u7f6e\u9884\u8b66\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        if (!ScanCodeWarningTypeEnum.PASS.getKey().equals(scanCodeWarning.getTerminalScanLocationConfig())) {
            Validate.notNull((Object)scanCodeWarning.getTerminalScanDistanceMax(), (String)"\u5f53\u9700\u8981\u6821\u9a8c\u7ec8\u7aef\u626b\u7801\u4f4d\u7f6e\u65f6\uff0c\u626b\u7801\u4f4d\u7f6e\u8ddd\u79bb\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Validate.isTrue((scanCodeWarning.getTerminalScanDistanceMax().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u5f53\u9700\u8981\u6821\u9a8c\u7ec8\u7aef\u626b\u7801\u4f4d\u7f6e\u65f6\uff0c\u626b\u7801\u4f4d\u7f6e\u8ddd\u79bb\u5fc5\u987b\u5927\u4e8e0!", (Object[])new Object[0]);
        }
        Validate.notNull((Object)scanCodeWarning.getConsumerScanLocationConfig(), (String)"\u8bf7\u8bbe\u7f6e\u6d88\u8d39\u8005-\u626b\u7801\u4f4d\u7f6e\u9884\u8b66\u914d\u7f6e", (Object[])new Object[0]);
        Validate.isTrue((boolean)ScanCodeWarningTypeEnum.contains((String)scanCodeWarning.getConsumerScanLocationConfig()), (String)"\u6d88\u8d39\u8005-\u626b\u7801\u4f4d\u7f6e\u9884\u8b66\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        if (!ScanCodeWarningTypeEnum.PASS.getKey().equals(scanCodeWarning.getConsumerScanLocationConfig())) {
            Validate.notNull((Object)scanCodeWarning.getConsumerScanDistanceMax(), (String)"\u5f53\u9700\u8981\u6821\u9a8c\u6d88\u8d39\u8005\u626b\u7801\u4f4d\u7f6e\u65f6\uff0c\u626b\u7801\u4f4d\u7f6e\u8ddd\u79bb\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Validate.isTrue((scanCodeWarning.getConsumerScanDistanceMax().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u5f53\u9700\u8981\u6821\u9a8c\u6d88\u8d39\u8005\u626b\u7801\u4f4d\u7f6e\u65f6\uff0c\u626b\u7801\u4f4d\u7f6e\u8ddd\u79bb\u5fc5\u987b\u5927\u4e8e0!", (Object[])new Object[0]);
        }
    }
}

