/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.barcode.local.service.notifier;

import com.biz.crm.cps.external.barcode.local.entity.ScanCodeRecord;
import com.biz.crm.cps.external.barcode.local.entity.ScanCodeWarning;
import com.biz.crm.cps.external.barcode.local.service.BarCodeLatestCirculationService;
import com.biz.crm.cps.external.barcode.local.service.ScanCodeRecordService;
import com.biz.crm.cps.external.barcode.local.service.ScanCodeWarningService;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeWarningTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeExceptionStrategyDto;
import com.biz.crm.cps.external.barcode.sdk.event.ScanCodeVerifyEventListener;
import com.biz.crm.cps.external.barcode.sdk.service.strategy.ScanCodeWarningStrategy;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeExceptionStrategyVo;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerScanLocationExceptionObserver
implements ScanCodeWarningStrategy {
    @Autowired
    private BarCodeLatestCirculationService barCodeLatestCirculationService;
    @Autowired
    private ScanCodeWarningService scanCodeWarningService;
    @Autowired(required=false)
    private List<ScanCodeVerifyEventListener> scanCodeVerifyEventListeners;
    @Autowired
    private ScanCodeRecordService scanCodeRecordService;

    public ScanCodeExceptionStrategyVo scanCodeValidation(ScanCodeExceptionStrategyDto scanCodeExceptionStrategyDto) {
        if (!scanCodeExceptionStrategyDto.getParticipatorType().equals(ParticipatorTypeEnum.CONSUMER.getCode())) {
            return null;
        }
        ScanCodeWarning scanCodeWarning = this.scanCodeWarningService.findScanCodeWarning();
        if (Objects.isNull((Object)scanCodeWarning) || scanCodeWarning.getConsumerScanLocationConfig().equals(ScanCodeWarningTypeEnum.PASS.getKey())) {
            return null;
        }
        ScanCodeExceptionStrategyVo scanCodeExceptionStrategyVo = new ScanCodeExceptionStrategyVo();
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{scanCodeExceptionStrategyDto.getLongitude(), scanCodeExceptionStrategyDto.getLongitude()})) {
            scanCodeExceptionStrategyVo.setScanCodeException(ScanCodeExceptionEnum.CUSTOMER_SCAN_LOCATION.getCode());
            scanCodeExceptionStrategyVo.setRemark(ScanCodeExceptionEnum.CUSTOMER_SCAN_LOCATION.getDes());
            return scanCodeExceptionStrategyVo;
        }
        ScanCodeRecord scanCodeRecord = this.scanCodeRecordService.findByBarCodeAndParticipatorType(scanCodeExceptionStrategyDto.getBarCode(), ParticipatorTypeEnum.TERMINAL.getCode(), ScanCodeExceptionEnum.NO.getCode(), ScanTypeEnum.ENTER_WAREHOUSE.getCode());
        if (ObjectUtils.isEmpty((Object)((Object)scanCodeRecord))) {
            return null;
        }
        scanCodeExceptionStrategyDto.setTerminalCode(scanCodeRecord.getTerminalCode());
        if (CollectionUtils.isNotEmpty(this.scanCodeVerifyEventListeners)) {
            for (ScanCodeVerifyEventListener listener : this.scanCodeVerifyEventListeners) {
                try {
                    listener.checkScanLocation(scanCodeExceptionStrategyDto, scanCodeWarning.getConsumerScanDistanceMax());
                }
                catch (Exception e) {
                    scanCodeExceptionStrategyVo.setScanCodeException(ScanCodeExceptionEnum.CUSTOMER_SCAN_LOCATION.getCode());
                    scanCodeExceptionStrategyVo.setRemark(ScanCodeExceptionEnum.CUSTOMER_SCAN_LOCATION.getDes());
                    return scanCodeExceptionStrategyVo;
                }
            }
        }
        return null;
    }
}

