/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.barcode.local.service.notifier;

import com.biz.crm.cps.external.barcode.local.entity.BarCodeLatestCirculation;
import com.biz.crm.cps.external.barcode.local.entity.ScanCodeWarning;
import com.biz.crm.cps.external.barcode.local.service.BarCodeLatestCirculationService;
import com.biz.crm.cps.external.barcode.local.service.ScanCodeWarningService;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeWarningTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeExceptionStrategyDto;
import com.biz.crm.cps.external.barcode.sdk.service.strategy.ScanCodeWarningStrategy;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeExceptionStrategyVo;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DealerCrossClientExceptionObserver
implements ScanCodeWarningStrategy {
    @Autowired
    private BarCodeLatestCirculationService barCodeLatestCirculationService;
    @Autowired
    private ScanCodeWarningService scanCodeWarningService;

    public ScanCodeExceptionStrategyVo scanCodeValidation(ScanCodeExceptionStrategyDto scanCodeExceptionStrategyDto) {
        if (!scanCodeExceptionStrategyDto.getParticipatorType().equals(ParticipatorTypeEnum.C.getCode())) {
            return null;
        }
        ScanCodeWarning scanCodeWarning = this.scanCodeWarningService.findScanCodeWarning();
        if (Objects.isNull((Object)scanCodeWarning) || scanCodeWarning.getDealerCrossClientConfig().equals(ScanCodeWarningTypeEnum.PASS.getKey())) {
            return null;
        }
        ScanCodeExceptionStrategyVo scanCodeExceptionStrategyVo = new ScanCodeExceptionStrategyVo();
        BarCodeLatestCirculation barCodeLatestCirculation = this.barCodeLatestCirculationService.findByBarCodeAndParticipatorType(scanCodeExceptionStrategyDto.getBarCode(), scanCodeExceptionStrategyDto.getParticipatorType());
        if (Objects.isNull((Object)barCodeLatestCirculation)) {
            return null;
        }
        scanCodeExceptionStrategyVo.setBarCodeParticipatorCode(barCodeLatestCirculation.getBarCodeParticipatorCode());
        if (!scanCodeExceptionStrategyDto.getScanParticipatorCode().equals(barCodeLatestCirculation.getBarCodeParticipatorCode())) {
            scanCodeExceptionStrategyVo.setRemark(ScanCodeExceptionEnum.DEALER_CROSS_CUSTOMER.getDes());
            if (scanCodeWarning.getDealerCrossClientConfig().equals(ScanCodeWarningTypeEnum.ALLOW.getKey())) {
                scanCodeExceptionStrategyVo.setScanCodeException(ScanCodeExceptionEnum.NO.getCode());
            } else {
                scanCodeExceptionStrategyVo.setScanCodeException(ScanCodeExceptionEnum.DEALER_CROSS_CUSTOMER.getCode());
            }
            return scanCodeExceptionStrategyVo;
        }
        return null;
    }
}

