/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.barcode.local.service.notifier;

import com.biz.crm.cps.external.barcode.local.entity.BarCodeLatestCirculation;
import com.biz.crm.cps.external.barcode.local.entity.ScanCodeRecord;
import com.biz.crm.cps.external.barcode.local.service.BarCodeLatestCirculationService;
import com.biz.crm.cps.external.barcode.local.service.ScanCodeRecordService;
import com.biz.crm.cps.external.barcode.sdk.common.enums.BarCodeTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeExceptionStrategyDto;
import com.biz.crm.cps.external.barcode.sdk.event.ScanCodeVerifyEventListener;
import com.biz.crm.cps.external.barcode.sdk.service.ScanCodeRecordVoService;
import com.biz.crm.cps.external.barcode.sdk.service.strategy.ScanCodeExceptionStrategy;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeExceptionStrategyVo;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeRecordVo;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DealerStorageScanCodeExceptionStrategyImpl
implements ScanCodeExceptionStrategy {
    @Autowired
    private BarCodeLatestCirculationService barCodeLatestCirculationService;
    @Autowired
    private ScanCodeRecordService scanCodeRecordService;
    @Autowired
    private ScanCodeRecordVoService scanCodeRecordVoService;
    @Autowired
    private List<ScanCodeVerifyEventListener> scanCodeVerifyEventListeners;

    public ScanCodeExceptionStrategyVo scanCodeValidation(ScanCodeExceptionStrategyDto scanCodeExceptionStrategyDto) {
        if (!ScanTypeEnum.ENTER_WAREHOUSE.getCode().equals(scanCodeExceptionStrategyDto.getScanType()) || !ParticipatorTypeEnum.C.getCode().equals(scanCodeExceptionStrategyDto.getParticipatorType())) {
            return null;
        }
        ScanCodeExceptionStrategyVo scanCodeExceptionStrategyVo = new ScanCodeExceptionStrategyVo();
        scanCodeExceptionStrategyVo.setScanCodeException(ScanCodeExceptionEnum.NO.getCode());
        BarCodeLatestCirculation barCodeLatestCirculation = this.barCodeLatestCirculationService.findByBarCodeAndParticipatorType(scanCodeExceptionStrategyDto.getBarCode(), scanCodeExceptionStrategyDto.getParticipatorType());
        if (Objects.nonNull((Object)barCodeLatestCirculation) && ScanTypeEnum.ENTER_WAREHOUSE.getCode().equals(barCodeLatestCirculation.getScanType())) {
            scanCodeExceptionStrategyVo.setBarCodeParticipatorCode(barCodeLatestCirculation.getBarCodeParticipatorCode());
            if (ScanCodeExceptionEnum.NO.getCode().equals(barCodeLatestCirculation.getScanCodeException())) {
                scanCodeExceptionStrategyVo.setScanCodeException(ScanCodeExceptionEnum.REPEAT_SCAN.getCode());
                scanCodeExceptionStrategyVo.setRemark(ScanCodeExceptionEnum.REPEAT_SCAN.getDes());
                return scanCodeExceptionStrategyVo;
            }
            scanCodeExceptionStrategyVo.setScanCodeException(barCodeLatestCirculation.getScanCodeException());
            scanCodeExceptionStrategyVo.setRemark(ScanCodeExceptionEnum.getDesc((String)barCodeLatestCirculation.getScanCodeException()));
            return scanCodeExceptionStrategyVo;
        }
        ScanCodeRecord scanCodeRecord = this.scanCodeRecordService.findByBarCodeAndParticipatorType(scanCodeExceptionStrategyDto.getBarCode(), ParticipatorTypeEnum.TERMINAL.getCode(), ScanCodeExceptionEnum.NO.getCode(), ScanTypeEnum.ENTER_WAREHOUSE.getCode());
        if (Objects.nonNull((Object)scanCodeRecord)) {
            scanCodeExceptionStrategyVo.setBarCodeParticipatorCode(scanCodeRecord.getBarCodeParticipatorCode());
            scanCodeExceptionStrategyVo.setScanCodeException(ScanCodeExceptionEnum.TERMINAL_ALREADY_STORAGE.getCode());
            scanCodeExceptionStrategyVo.setRemark(ScanCodeExceptionEnum.TERMINAL_ALREADY_STORAGE.getDes());
            return scanCodeExceptionStrategyVo;
        }
        List scanCodeRecords = this.scanCodeRecordVoService.findByScanParticipatorCode(scanCodeExceptionStrategyDto.getScanParticipatorCode());
        List collect = scanCodeRecords.stream().filter(scanCodeRecord1 -> scanCodeRecord1.getFlatAncestors().contains(scanCodeExceptionStrategyDto.getBarCode()) && ScanTypeEnum.ENTER_WAREHOUSE.getCode().equals(scanCodeRecord1.getScanType())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)) {
            for (ScanCodeRecordVo recordVo : collect) {
                if (BarCodeTypeEnum.BOX.getFlag().equals(recordVo.getBarCodeType())) {
                    scanCodeExceptionStrategyVo.setBarCodeParticipatorCode(recordVo.getBarCodeParticipatorCode());
                    scanCodeExceptionStrategyVo.setScanCodeException(ScanCodeExceptionEnum.BOX.getCode());
                    scanCodeExceptionStrategyVo.setRemark(ScanCodeExceptionEnum.BOX.getDes());
                    return scanCodeExceptionStrategyVo;
                }
                if (!BarCodeTypeEnum.BOTTLE.getFlag().equals(recordVo.getBarCodeType()) || !BarCodeTypeEnum.BOX.getFlag().equals(scanCodeExceptionStrategyDto.getBarCodeType())) continue;
                scanCodeExceptionStrategyVo.setBarCodeParticipatorCode(recordVo.getBarCodeParticipatorCode());
                scanCodeExceptionStrategyVo.setScanCodeException(ScanCodeExceptionEnum.BOTTLE.getCode());
                scanCodeExceptionStrategyVo.setRemark(ScanCodeExceptionEnum.BOTTLE.getDes());
                return scanCodeExceptionStrategyVo;
            }
        }
        return scanCodeExceptionStrategyVo;
    }
}

