/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.barcode.local.service.notifier;

import com.biz.crm.cps.external.barcode.local.entity.BarCodeLatestCirculation;
import com.biz.crm.cps.external.barcode.local.entity.ScanCodeWarning;
import com.biz.crm.cps.external.barcode.local.service.BarCodeLatestCirculationService;
import com.biz.crm.cps.external.barcode.local.service.ScanCodeWarningService;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeWarningTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.dto.BarCodeEventDto;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeExceptionStrategyDto;
import com.biz.crm.cps.external.barcode.sdk.event.BarCodeMaterialStandardEventListener;
import com.biz.crm.cps.external.barcode.sdk.event.ScanCodeVerifyEventListener;
import com.biz.crm.cps.external.barcode.sdk.service.strategy.ScanCodeWarningStrategy;
import com.biz.crm.cps.external.barcode.sdk.vo.BarCodeMaterialVo;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeExceptionStrategyVo;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotAssignSupplyProductExceptionObserver
implements ScanCodeWarningStrategy {
    @Autowired
    private BarCodeLatestCirculationService barCodeLatestCirculationService;
    @Autowired
    private ScanCodeWarningService scanCodeWarningService;
    @Autowired
    private BarCodeMaterialStandardEventListener barCodeMaterialStandardEventListener;
    @Autowired(required=false)
    private List<ScanCodeVerifyEventListener> scanCodeVerifyEventListeners;

    public ScanCodeExceptionStrategyVo scanCodeValidation(ScanCodeExceptionStrategyDto scanCodeExceptionStrategyDto) {
        if (!scanCodeExceptionStrategyDto.getParticipatorType().equals(ParticipatorTypeEnum.TERMINAL.getCode())) {
            return null;
        }
        ScanCodeWarning scanCodeWarning = this.scanCodeWarningService.findScanCodeWarning();
        if (Objects.isNull((Object)scanCodeWarning) || scanCodeWarning.getNotAssignSupplyProductConfig().equals(ScanCodeWarningTypeEnum.PASS.getKey())) {
            return null;
        }
        ScanCodeExceptionStrategyVo scanCodeExceptionStrategyVo = new ScanCodeExceptionStrategyVo();
        BarCodeLatestCirculation barCodeLatestCirculation = this.barCodeLatestCirculationService.findByBarCodeAndParticipatorType(scanCodeExceptionStrategyDto.getBarCode(), scanCodeExceptionStrategyDto.getParticipatorType());
        if (Objects.isNull((Object)barCodeLatestCirculation)) {
            return null;
        }
        BarCodeEventDto barCodeEventDto = new BarCodeEventDto();
        barCodeEventDto.setProductCode(scanCodeExceptionStrategyDto.getProductCode());
        BarCodeMaterialVo barCodeMaterialVo = this.barCodeMaterialStandardEventListener.onRequestMaterial(barCodeEventDto);
        if (ObjectUtils.isEmpty((Object)barCodeMaterialVo)) {
            return null;
        }
        barCodeMaterialVo.setTerminalCode(scanCodeExceptionStrategyDto.getScanParticipatorCode());
        if (CollectionUtils.isNotEmpty(this.scanCodeVerifyEventListeners)) {
            for (ScanCodeVerifyEventListener listener : this.scanCodeVerifyEventListeners) {
                try {
                    listener.checkTerminalSupply(barCodeMaterialVo);
                }
                catch (Exception e) {
                    scanCodeExceptionStrategyVo.setScanCodeException(ScanCodeExceptionEnum.NOT_ASSIGN_SUPPLY_PRODUCT.getCode());
                    scanCodeExceptionStrategyVo.setRemark(ScanCodeExceptionEnum.NOT_ASSIGN_SUPPLY_PRODUCT.getDes());
                    scanCodeExceptionStrategyVo.setAllowConfig(scanCodeWarning.getNotAssignSupplyProductConfig());
                    return scanCodeExceptionStrategyVo;
                }
            }
        }
        return null;
    }
}

