/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.barcode.local.service.notifier;

import com.biz.crm.cps.external.barcode.local.entity.ScanCodeRecord;
import com.biz.crm.cps.external.barcode.local.entity.ScanCodeWarning;
import com.biz.crm.cps.external.barcode.local.service.ScanCodeRecordService;
import com.biz.crm.cps.external.barcode.local.service.ScanCodeWarningService;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeWarningTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeExceptionStrategyDto;
import com.biz.crm.cps.external.barcode.sdk.service.strategy.ScanCodeWarningStrategy;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeExceptionStrategyVo;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotAssignTerminalExceptionObserver
implements ScanCodeWarningStrategy {
    @Autowired
    private ScanCodeRecordService scanCodeRecordService;
    @Autowired
    private ScanCodeWarningService scanCodeWarningService;

    public ScanCodeExceptionStrategyVo scanCodeValidation(ScanCodeExceptionStrategyDto scanCodeExceptionStrategyDto) {
        if (!scanCodeExceptionStrategyDto.getParticipatorType().equals(ParticipatorTypeEnum.TERMINAL.getCode())) {
            return null;
        }
        ScanCodeWarning scanCodeWarning = this.scanCodeWarningService.findScanCodeWarning();
        if (Objects.isNull((Object)scanCodeWarning) || scanCodeWarning.getNotAssignTerminalConfig().equals(ScanCodeWarningTypeEnum.PASS.getKey())) {
            return null;
        }
        ScanCodeExceptionStrategyVo scanCodeExceptionStrategyVo = new ScanCodeExceptionStrategyVo();
        ScanCodeRecord scanCodeRecord = this.scanCodeRecordService.findByBarCodeAndParticipatorType(scanCodeExceptionStrategyDto.getBarCode(), ParticipatorTypeEnum.C.getCode(), ScanCodeExceptionEnum.NO.getCode(), ScanTypeEnum.OUT_WAREHOUSE.getCode());
        if (ObjectUtils.isEmpty((Object)((Object)scanCodeRecord))) {
            return null;
        }
        scanCodeExceptionStrategyVo.setBarCodeParticipatorCode(scanCodeRecord.getBarCodeParticipatorCode());
        if (!scanCodeExceptionStrategyDto.getScanParticipatorCode().equals(scanCodeRecord.getTerminalCode())) {
            scanCodeExceptionStrategyVo.setRemark(ScanCodeExceptionEnum.NOT_ASSIGN_TERMINAL.getDes());
            if (scanCodeWarning.getDealerCrossClientConfig().equals(ScanCodeWarningTypeEnum.ALLOW.getKey())) {
                scanCodeExceptionStrategyVo.setScanCodeException(ScanCodeExceptionEnum.NO.getCode());
            } else {
                scanCodeExceptionStrategyVo.setScanCodeException(ScanCodeExceptionEnum.NOT_ASSIGN_TERMINAL.getCode());
            }
            scanCodeExceptionStrategyVo.setAllowConfig(scanCodeWarning.getNotAssignTerminalConfig());
            return scanCodeExceptionStrategyVo;
        }
        return null;
    }
}

