/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.barcode.local.service.notifier;

import com.biz.crm.cps.external.barcode.local.entity.ScanCodeRecord;
import com.biz.crm.cps.external.barcode.local.entity.ScanCodeWarning;
import com.biz.crm.cps.external.barcode.local.service.ScanCodeRecordService;
import com.biz.crm.cps.external.barcode.local.service.ScanCodeWarningService;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeWarningTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeExceptionStrategyDto;
import com.biz.crm.cps.external.barcode.sdk.service.strategy.ScanCodeWarningStrategy;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeExceptionStrategyVo;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TerminalCodeNotInboundExceptionObserver
implements ScanCodeWarningStrategy {
    @Autowired
    private ScanCodeWarningService scanCodeWarningService;
    @Autowired
    private ScanCodeRecordService scanCodeRecordService;

    public ScanCodeExceptionStrategyVo scanCodeValidation(ScanCodeExceptionStrategyDto scanCodeExceptionStrategyDto) {
        if (!scanCodeExceptionStrategyDto.getParticipatorType().equals(ParticipatorTypeEnum.TERMINAL.getCode())) {
            return null;
        }
        ScanCodeWarning scanCodeWarning = this.scanCodeWarningService.findScanCodeWarning();
        if (Objects.isNull((Object)scanCodeWarning) || scanCodeWarning.getTerminalCodeNotInbound().equals(ScanCodeWarningTypeEnum.PASS.getKey())) {
            return null;
        }
        ScanCodeRecord scanCodeRecord = this.scanCodeRecordService.findByBarCodeAndParticipatorType(scanCodeExceptionStrategyDto.getBarCode(), ParticipatorTypeEnum.C.getCode(), ScanCodeExceptionEnum.NO.getCode(), ScanTypeEnum.ENTER_WAREHOUSE.getCode());
        if (Objects.isNull((Object)scanCodeRecord)) {
            ScanCodeExceptionStrategyVo scanCodeExceptionStrategyVo = new ScanCodeExceptionStrategyVo();
            scanCodeExceptionStrategyVo.setBarCodeParticipatorCode(scanCodeExceptionStrategyDto.getScanParticipatorCode());
            scanCodeExceptionStrategyVo.setScanCodeException(ScanCodeExceptionEnum.TERMINAL_CODE_NOT_INBOUND.getCode());
            scanCodeExceptionStrategyVo.setRemark(ScanCodeExceptionEnum.TERMINAL_CODE_NOT_INBOUND.getDes());
            scanCodeExceptionStrategyVo.setAllowConfig(scanCodeWarning.getTerminalCodeNotInbound());
            return scanCodeExceptionStrategyVo;
        }
        return null;
    }
}

