/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.barcode.local.service.notifier;

import com.biz.crm.cps.external.barcode.local.entity.ScanCodeRecord;
import com.biz.crm.cps.external.barcode.local.entity.ScanCodeWarning;
import com.biz.crm.cps.external.barcode.local.service.ScanCodeRecordService;
import com.biz.crm.cps.external.barcode.local.service.ScanCodeWarningService;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeWarningTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeExceptionStrategyDto;
import com.biz.crm.cps.external.barcode.sdk.event.ScanCodeVerifyEventListener;
import com.biz.crm.cps.external.barcode.sdk.service.strategy.ScanCodeWarningStrategy;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeExceptionStrategyVo;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TerminalCrossChannelExceptionObserver
implements ScanCodeWarningStrategy {
    @Autowired
    private ScanCodeWarningService scanCodeWarningService;
    @Autowired
    private ScanCodeRecordService scanCodeRecordService;
    @Autowired(required=false)
    private List<ScanCodeVerifyEventListener> scanCodeVerifyEventListeners;

    public ScanCodeExceptionStrategyVo scanCodeValidation(ScanCodeExceptionStrategyDto scanCodeExceptionStrategyDto) {
        if (!scanCodeExceptionStrategyDto.getParticipatorType().equals(ParticipatorTypeEnum.TERMINAL.getCode())) {
            return null;
        }
        ScanCodeWarning scanCodeWarning = this.scanCodeWarningService.findScanCodeWarning();
        if (Objects.isNull((Object)scanCodeWarning) || scanCodeWarning.getTerminalCrossChannelConfig().equals(ScanCodeWarningTypeEnum.PASS.getKey())) {
            return null;
        }
        ScanCodeExceptionStrategyVo scanCodeExceptionStrategyVo = new ScanCodeExceptionStrategyVo();
        ScanCodeRecord scanCodeRecord = this.scanCodeRecordService.findByBarCodeAndParticipatorType(scanCodeExceptionStrategyDto.getBarCode(), ParticipatorTypeEnum.C.getCode(), ScanCodeExceptionEnum.NO.getCode(), ScanTypeEnum.OUT_WAREHOUSE.getCode());
        if (ObjectUtils.isEmpty((Object)((Object)scanCodeRecord))) {
            scanCodeExceptionStrategyVo.setScanCodeException(ScanCodeExceptionEnum.TERMINAL_CODE_NOT_OUTBOUND.getCode());
            scanCodeExceptionStrategyVo.setRemark(ScanCodeExceptionEnum.TERMINAL_CODE_NOT_OUTBOUND.getDes());
            scanCodeExceptionStrategyVo.setAllowConfig(scanCodeWarning.getTerminalCrossChannelConfig());
            return scanCodeExceptionStrategyVo;
        }
        if (CollectionUtils.isNotEmpty(this.scanCodeVerifyEventListeners)) {
            for (ScanCodeVerifyEventListener listener : this.scanCodeVerifyEventListeners) {
                try {
                    listener.checkTerminalChannel(scanCodeExceptionStrategyDto);
                }
                catch (Exception e) {
                    scanCodeExceptionStrategyVo.setScanCodeException(ScanCodeExceptionEnum.TERMINAL_CROSS_CHANNEL.getCode());
                    scanCodeExceptionStrategyVo.setRemark(ScanCodeExceptionEnum.TERMINAL_CROSS_CHANNEL.getDes());
                    return scanCodeExceptionStrategyVo;
                }
            }
        }
        return null;
    }
}

