/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.barcode.local.service.notifier;

import com.biz.crm.cps.external.barcode.local.entity.ScanCodeRecord;
import com.biz.crm.cps.external.barcode.local.entity.ScanCodeWarning;
import com.biz.crm.cps.external.barcode.local.service.ScanCodeRecordService;
import com.biz.crm.cps.external.barcode.local.service.ScanCodeWarningService;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeWarningTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeExceptionStrategyDto;
import com.biz.crm.cps.external.barcode.sdk.event.ScanCodeVerifyEventListener;
import com.biz.crm.cps.external.barcode.sdk.service.strategy.ScanCodeWarningStrategy;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeExceptionStrategyVo;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TerminalCrossClientExceptionObserver
implements ScanCodeWarningStrategy {
    @Autowired
    private ScanCodeRecordService scanCodeRecordService;
    @Autowired
    private ScanCodeWarningService scanCodeWarningService;
    @Autowired
    private List<ScanCodeVerifyEventListener> scanCodeVerifyEventListeners;

    public ScanCodeExceptionStrategyVo scanCodeValidation(ScanCodeExceptionStrategyDto scanCodeExceptionStrategyDto) {
        Iterator<ScanCodeVerifyEventListener> iterator;
        if (!scanCodeExceptionStrategyDto.getParticipatorType().equals(ParticipatorTypeEnum.TERMINAL.getCode())) {
            return null;
        }
        ScanCodeWarning scanCodeWarning = this.scanCodeWarningService.findScanCodeWarning();
        if (Objects.isNull((Object)scanCodeWarning) || scanCodeWarning.getTerminalCrossClientConfig().equals(ScanCodeWarningTypeEnum.PASS.getKey())) {
            return null;
        }
        ScanCodeRecord scanCodeRecord = this.scanCodeRecordService.findByBarCodeAndParticipatorType(scanCodeExceptionStrategyDto.getBarCode(), ParticipatorTypeEnum.C.getCode(), ScanCodeExceptionEnum.NO.getCode(), ScanTypeEnum.OUT_WAREHOUSE.getCode());
        if (ObjectUtils.isEmpty((Object)((Object)scanCodeRecord))) {
            return null;
        }
        ScanCodeExceptionStrategyVo scanCodeExceptionStrategyVo = new ScanCodeExceptionStrategyVo();
        if (CollectionUtils.isNotEmpty(this.scanCodeVerifyEventListeners) && (iterator = this.scanCodeVerifyEventListeners.iterator()).hasNext()) {
            ScanCodeVerifyEventListener listener = iterator.next();
            try {
                listener.checkTerminalSupplyDealer(scanCodeExceptionStrategyDto, scanCodeRecord.getBarCodeParticipatorCode());
            }
            catch (Exception e) {
                scanCodeExceptionStrategyVo.setBarCodeParticipatorCode(scanCodeRecord.getBarCodeParticipatorCode());
                scanCodeExceptionStrategyVo.setRemark(ScanCodeExceptionEnum.TERMINAL_CROSS_CUSTOMER.getDes());
                if (scanCodeWarning.getDealerCrossClientConfig().equals(ScanCodeWarningTypeEnum.ALLOW.getKey())) {
                    scanCodeExceptionStrategyVo.setScanCodeException(ScanCodeExceptionEnum.NO.getCode());
                } else {
                    scanCodeExceptionStrategyVo.setScanCodeException(ScanCodeExceptionEnum.TERMINAL_CROSS_CUSTOMER.getCode());
                }
                scanCodeExceptionStrategyVo.setAllowConfig(scanCodeWarning.getTerminalCrossClientConfig());
                return scanCodeExceptionStrategyVo;
            }
            return null;
        }
        return null;
    }
}

