/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.barcode.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.external.barcode.local.entity.ScanCodeRecord;
import com.biz.crm.cps.external.barcode.local.mapper.ScanCodeRecordMapper;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordDto;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ScanCodeRecordRepository
extends ServiceImpl<ScanCodeRecordMapper, ScanCodeRecord> {
    @Resource
    private ScanCodeRecordMapper scanCodeRecordMapper;

    public ScanCodeRecord findByScanCodeRecordDto(ScanCodeRecordDto dto) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"bar_code", (Object)dto.getBarCode());
        queryWrapper.eq((Object)"participator_type", (Object)dto.getParticipatorType());
        queryWrapper.eq((Object)"scan_code_exception", (Object)ScanCodeExceptionEnum.NO.getCode());
        return (ScanCodeRecord)((Object)this.getOne((Wrapper)queryWrapper));
    }

    public ScanCodeRecord findByBarCodeAndScanType(String barCode, String scanType, String participatorType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"bar_code", (Object)barCode);
        queryWrapper.eq((Object)"scan_type", (Object)scanType);
        queryWrapper.orderByAsc((Object)"create_time");
        List list = this.list((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return (ScanCodeRecord)((Object)list.get(0));
        }
        return null;
    }

    public void updateJudgeStatus(String recordCode, String scanCodeJudge) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"scan_code_judge", (Object)scanCodeJudge);
        updateWrapper.eq((Object)"record_code", (Object)recordCode);
        this.update((Wrapper)updateWrapper);
    }

    public ScanCodeRecord findDealerRecord(ScanCodeRecordDto dto) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"bar_code", (Object)dto.getBarCode());
        queryWrapper.eq((Object)"participator_type", (Object)ParticipatorTypeEnum.DEALER.getDictCode());
        queryWrapper.eq((Object)"scan_code_exception", (Object)ScanCodeExceptionEnum.NO.getCode());
        return (ScanCodeRecord)((Object)this.getOne((Wrapper)queryWrapper));
    }

    public ScanCodeRecord findAllDealerRecordByBarCode(ScanCodeRecordDto dto) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"bar_code", (Object)dto.getBarCode());
        queryWrapper.eq((Object)"participator_type", (Object)ParticipatorTypeEnum.DEALER.getDictCode());
        return (ScanCodeRecord)((Object)this.getOne((Wrapper)queryWrapper));
    }

    public int findRangeCountByProductCode(String productCode) {
        return this.scanCodeRecordMapper.findRangeCountByProductCode(productCode);
    }
}

