/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.barcode.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.common.sdk.enums.SendEnum;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.external.barcode.local.entity.ScanCodeRecord;
import com.biz.crm.cps.external.barcode.local.mapper.ScanCodeRecordMapper;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordDto;
import com.biz.crm.cps.external.barcode.sdk.vo.DealerScanCodeRecordVo;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeRecordVo;
import com.biz.crm.cps.external.barcode.sdk.vo.TerminalScanCodeRecordVo;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ScanCodeRecordRepository
extends ServiceImpl<ScanCodeRecordMapper, ScanCodeRecord> {
    @Resource
    private ScanCodeRecordMapper scanCodeRecordMapper;

    public ScanCodeRecord findByBarCodeAndParticipatorType(String barCode, String participatorType, String scanCodeException) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"bar_code", (Object)barCode);
        queryWrapper.eq((Object)"participator_type", (Object)participatorType);
        queryWrapper.eq((Object)"scan_code_exception", (Object)scanCodeException);
        return (ScanCodeRecord)((Object)this.getOne((Wrapper)queryWrapper));
    }

    public ScanCodeRecord findByBarCodeAndScanType(String barCode, String scanType, String participatorType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"bar_code", (Object)barCode);
        queryWrapper.eq((Object)"scan_type", (Object)scanType);
        if (StringUtils.isNotBlank((CharSequence)participatorType)) {
            queryWrapper.eq((Object)"participator_type", (Object)participatorType);
        }
        queryWrapper.orderByAsc((Object)"create_time");
        List list = this.list((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return (ScanCodeRecord)((Object)list.get(0));
        }
        return null;
    }

    public void updateJudgeStatus(String recordCode, String scanCodeJudge) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"scan_code_judge", (Object)scanCodeJudge);
        updateWrapper.eq((Object)"record_code", (Object)recordCode);
        this.update((Wrapper)updateWrapper);
    }

    public ScanCodeRecord findDealerRecord(ScanCodeRecordDto dto) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"bar_code", (Object)dto.getBarCode());
        queryWrapper.eq((Object)"participator_type", (Object)ParticipatorTypeEnum.DEALER.getDictCode());
        queryWrapper.eq((Object)"scan_code_exception", (Object)ScanCodeExceptionEnum.NO.getCode());
        return (ScanCodeRecord)((Object)this.getOne((Wrapper)queryWrapper));
    }

    public ScanCodeRecord findByBarCodeAndScanTypeAndJudge(String barCode, String scanType, String participatorType, List<String> judges) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"bar_code", (Object)barCode);
        queryWrapper.eq((Object)"scan_type", (Object)scanType);
        if (StringUtils.isNotBlank((CharSequence)participatorType)) {
            queryWrapper.eq((Object)"participator_type", (Object)participatorType);
        }
        if (!CollectionUtils.isEmpty(judges)) {
            queryWrapper.in((Object)"scan_code_judge", judges);
        }
        queryWrapper.orderByAsc((Object)"create_time");
        List list = this.list((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return (ScanCodeRecord)((Object)list.get(0));
        }
        return null;
    }

    public ScanCodeRecord findAllDealerRecordByBarCode(ScanCodeRecordDto dto) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"bar_code", (Object)dto.getBarCode());
        queryWrapper.eq((Object)"participator_type", (Object)ParticipatorTypeEnum.DEALER.getDictCode());
        return (ScanCodeRecord)((Object)this.getOne((Wrapper)queryWrapper));
    }

    public int findRangeCountByBarCode(String barCode) {
        return this.scanCodeRecordMapper.findRangeCountByBarCode(barCode);
    }

    public ScanCodeRecord findByRecordCode(String recordCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"record_code", (Object)recordCode);
        return (ScanCodeRecord)((Object)this.getOne((Wrapper)queryWrapper));
    }

    public void updateTjSendStatus(List<ScanCodeRecordVo> failRecord) {
        this.scanCodeRecordMapper.updateTjSendStatus(failRecord, SendEnum.NO.getCode());
    }

    public List<DealerScanCodeRecordVo> findDealerScanCodeRecordRecordByDate(Date startTime, Date endTime, List<String> judges) {
        return this.scanCodeRecordMapper.findDealerScanCodeRecordRecordByDate(startTime, endTime, judges);
    }

    public List<TerminalScanCodeRecordVo> findTerminalScanCodeRecordByDate(Date startTime, Date endTime) {
        return this.scanCodeRecordMapper.findTerminalScanCodeRecordByDate(startTime, endTime);
    }

    public ScanCodeRecord findByBarCode(String barCode, String participatorType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"bar_code", (Object)barCode);
        if (StringUtils.isNotBlank((CharSequence)participatorType)) {
            queryWrapper.eq((Object)"participator_type", (Object)participatorType);
        }
        return (ScanCodeRecord)((Object)this.getOne((Wrapper)queryWrapper));
    }
}

