/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.barcode.local.service.internal;

import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.biz.crm.cps.external.barcode.local.config.BarCodeConfig;
import com.biz.crm.cps.external.barcode.local.entity.BarCode;
import com.biz.crm.cps.external.barcode.local.repository.BarCodeRepository;
import com.biz.crm.cps.external.barcode.sdk.dto.BarCodeDto;
import com.biz.crm.cps.external.barcode.sdk.dto.BarCodeEventDto;
import com.biz.crm.cps.external.barcode.sdk.event.BarCodeMaterialStandardEventListener;
import com.biz.crm.cps.external.barcode.sdk.service.BarCodeVoService;
import com.biz.crm.cps.external.barcode.sdk.vo.BarCodeMaterialStandardUnitVo;
import com.biz.crm.cps.external.barcode.sdk.vo.BarCodeVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class BarCodeVoServiceImpl
implements BarCodeVoService {
    @Resource
    private BarCodeRepository barCodeRepository;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private BarCodeMaterialStandardEventListener barCodeMaterialStandardEventListener;
    @Autowired
    private BarCodeConfig barCodeConfig;

    @Transactional
    public List<BarCodeVo> create(List<BarCodeDto> barCodeDtos) {
        List<BarCode> barCodes = this.createForm(barCodeDtos);
        this.barCodeRepository.saveBatch(barCodes);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(barCodes, BarCode.class, BarCodeVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public BarCodeVo create(BarCodeDto barCodeDto) {
        this.createValidation(barCodeDto);
        BarCode byBarCode = this.barCodeRepository.findByBarCode(barCodeDto.getBarCode());
        if (ObjectUtils.isNotNull((Object[])new Object[]{byBarCode})) {
            throw new RuntimeException("\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u5f53\u524d\u6761\u7801\u6570\u636e\u5df2\u5b58\u5728");
        }
        barCodeDto.setTenantCode(TenantUtils.getTenantCode());
        ArrayList<BarCodeDto> barCodeDtos = new ArrayList<BarCodeDto>();
        barCodeDtos.add(barCodeDto);
        this.buildBarCodeDtos(Lists.newArrayList(barCodeDtos));
        BarCode barCode = (BarCode)((Object)this.nebulaToolkitService.copyObjectByWhiteList(barCodeDtos.get(0), BarCode.class, HashSet.class, ArrayList.class, new String[0]));
        this.barCodeRepository.save((Object)barCode);
        return (BarCodeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)barCode, BarCodeVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<BarCodeVo> findByBarCodes(List<String> barCodes) {
        if (CollectionUtils.isEmpty(barCodes)) {
            return null;
        }
        List<BarCode> byBarCodes = this.barCodeRepository.findByBarCodes(barCodes);
        if (CollectionUtils.isEmpty(byBarCodes)) {
            return null;
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(byBarCodes, BarCode.class, BarCodeVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public BarCodeVo findByBarCode(String barCode) {
        if (StringUtils.isBlank((CharSequence)barCode)) {
            return null;
        }
        BarCode byBarCode = this.barCodeRepository.findByBarCode(barCode);
        if (Objects.isNull((Object)byBarCode)) {
            return null;
        }
        return (BarCodeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)byBarCode, BarCodeVo.class, null, null, new String[0]);
    }

    private List<BarCode> createForm(List<BarCodeDto> barCodeDtos) {
        ArrayList<String> codes = new ArrayList<String>();
        ArrayList<BarCodeDto> barCodeVoList = new ArrayList<BarCodeDto>();
        Validate.isTrue((!CollectionUtils.isEmpty(barCodeDtos) ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u8bc6\u522b\u8be5\u7801\uff01", (Object[])new Object[0]);
        barCodeDtos.stream().forEach(barCodeDto -> {
            codes.add(barCodeDto.getBarCode());
            barCodeDto.setFlatAncestors("0," + barCodeDto.getBarCode());
            barCodeDto.setTenantCode(TenantUtils.getTenantCode());
            this.createValidation((BarCodeDto)barCodeDto);
            barCodeVoList.add((BarCodeDto)barCodeDto);
            List childrenBarCode = barCodeDto.getChildrenBarCode();
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)childrenBarCode) ? 1 : 0) != 0, (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u65b0\u589e\u76d2\u7801\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            childrenBarCode.stream().forEach(barCodeDtoTwo -> {
                Validate.isTrue((!barCodeDto.getBarCode().equals(barCodeDtoTwo.getParentBarCode()) ? 1 : 0) != 0, (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u76d2\u7801\u5bf9\u5e94\u7684\u7236\u7ea7\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
                codes.add(barCodeDtoTwo.getBarCode());
                barCodeDtoTwo.setFlatAncestors(barCodeDto.getBarCode() + "," + barCodeDtoTwo.getBarCode());
                barCodeDtoTwo.setTenantCode(TenantUtils.getTenantCode());
                this.createValidation((BarCodeDto)barCodeDtoTwo);
                barCodeVoList.add((BarCodeDto)barCodeDtoTwo);
                if ("true".equals(this.barCodeConfig.getEnableCoverCode())) {
                    List childrenBarCodeTwo = barCodeDtoTwo.getChildrenBarCode();
                    Validate.isTrue((!CollectionUtils.isEmpty((Collection)childrenBarCodeTwo) ? 1 : 0) != 0, (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u65b0\u589e\u76d6\u5185\u7801\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    childrenBarCodeTwo.stream().forEach(barCodeDtoThree -> {
                        Validate.isTrue((!barCodeDto.getBarCode().equals(barCodeDtoTwo.getParentBarCode()) ? 1 : 0) != 0, (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u76d6\u5185\u7801\u5bf9\u5e94\u7684\u7236\u7ea7\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
                        codes.add(barCodeDtoThree.getBarCode());
                        barCodeDtoThree.setFlatAncestors(barCodeDto.getBarCode() + "," + barCodeDtoTwo.getBarCode() + "," + barCodeDtoThree.getBarCode());
                        barCodeDtoThree.setTenantCode(TenantUtils.getTenantCode());
                        this.createValidation((BarCodeDto)barCodeDtoThree);
                        barCodeVoList.add((BarCodeDto)barCodeDtoThree);
                    });
                }
            });
        });
        HashSet set = new HashSet(codes);
        Validate.isTrue((set.size() == codes.size() ? 1 : 0) != 0, (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u7801\u6811\u7ed3\u6784\u6570\u636e\u5b58\u5728\u91cd\u590d\u7801\uff01", (Object[])new Object[0]);
        List<BarCode> barCodes = this.barCodeRepository.findByBarCodes(codes);
        Validate.isTrue((!CollectionUtils.isEmpty(barCodes) ? 1 : 0) != 0, (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u7801\u6811\u7ed3\u6784\u6570\u636e\u5b58\u5728\uff01", (Object[])new Object[0]);
        this.buildBarCodeDtos(barCodeVoList);
        List barCodeVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(barCodeVoList, BarCodeDto.class, BarCode.class, HashSet.class, ArrayList.class, new String[0]);
        return barCodeVos;
    }

    private void createValidation(BarCodeDto dto) {
        Validate.notNull((Object)dto, (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u65b0\u589e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBarCode(), (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u6761\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getFlatAncestors(), (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u62c9\u5e73\u540e\u7684\u7956\u7ea7\u7ed3\u6784\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBarCodeType(), (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u6761\u7801\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getProductCode(), (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u5546\u54c1\u552f\u4e00\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void buildBarCodeDtos(List<BarCodeDto> barCodeDtos) {
        if (CollectionUtils.isEmpty(barCodeDtos) || this.barCodeMaterialStandardEventListener == null) {
            return;
        }
        List barCodeEventDtos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(barCodeDtos, BarCodeDto.class, BarCodeEventDto.class, HashSet.class, ArrayList.class, new String[0]);
        List materialStandardUnitVos = this.barCodeMaterialStandardEventListener.onRequestMaterialStandardUnit(barCodeEventDtos);
        if (CollectionUtils.isEmpty((Collection)materialStandardUnitVos)) {
            return;
        }
        Map<String, BarCodeMaterialStandardUnitVo> collect = materialStandardUnitVos.stream().collect(Collectors.toMap(BarCodeMaterialStandardUnitVo::getBarCode, materialStandardUnitVo -> materialStandardUnitVo));
        barCodeDtos.stream().forEach(barCodeDto -> {
            BarCodeMaterialStandardUnitVo vo = (BarCodeMaterialStandardUnitVo)collect.get(barCodeDto.getBarCode());
            if (vo != null) {
                barCodeDto.setStandardUnitBoxValue(vo.getStandardUnitBoxValue());
                barCodeDto.setStandardUnitBottleValue(vo.getStandardUnitBottleValue());
            }
        });
    }
}

