/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.barcode.local.service.internal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.agreement.sdk.common.enums.AgreementStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.common.enums.SignStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementTemplateVoService;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementTemplateVo;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.vo.LoginUserDetails;
import com.biz.crm.cps.business.participator.local.entity.DealerCommunicationEntity;
import com.biz.crm.cps.business.participator.local.entity.DealerEntity;
import com.biz.crm.cps.business.participator.local.entity.SupplyRelationship;
import com.biz.crm.cps.business.participator.local.entity.SupplyRelationshipDetail;
import com.biz.crm.cps.business.participator.local.entity.Terminal;
import com.biz.crm.cps.business.participator.local.repository.DealerRepository;
import com.biz.crm.cps.business.participator.local.repository.SupplyRelationshipRepository;
import com.biz.crm.cps.business.participator.local.repository.TerminalRepository;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.external.barcode.local.config.BarCodeConfig;
import com.biz.crm.cps.external.barcode.local.entity.BarCode;
import com.biz.crm.cps.external.barcode.local.entity.BarCodeLatestCirculation;
import com.biz.crm.cps.external.barcode.local.entity.ConsumerScanProductMapping;
import com.biz.crm.cps.external.barcode.local.entity.ScanCodeChannel;
import com.biz.crm.cps.external.barcode.local.entity.ScanCodeRecord;
import com.biz.crm.cps.external.barcode.local.entity.ScanCodeRecordFactory;
import com.biz.crm.cps.external.barcode.local.repository.BarCodeLatestCirculationRepository;
import com.biz.crm.cps.external.barcode.local.repository.BarCodeRepository;
import com.biz.crm.cps.external.barcode.local.repository.ConsumerScanProductMappingRepository;
import com.biz.crm.cps.external.barcode.local.repository.ScanCodeChannelRepository;
import com.biz.crm.cps.external.barcode.local.repository.ScanCodeRecordFactoryRepository;
import com.biz.crm.cps.external.barcode.local.repository.ScanCodeRecordRepository;
import com.biz.crm.cps.external.barcode.local.repository.ScanCodeRecordVoRepository;
import com.biz.crm.cps.external.barcode.sdk.common.enums.BarCodeTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.EnterTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeJudgeEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.dto.BarCodeDto;
import com.biz.crm.cps.external.barcode.sdk.dto.ConsumerScanCodeDto;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordChannelDto;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordDto;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordEventDto;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordPageDto;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordStatisticsDto;
import com.biz.crm.cps.external.barcode.sdk.event.ConsumerScanCodeRecordEventListener;
import com.biz.crm.cps.external.barcode.sdk.event.ScanCodeRecordEventListener;
import com.biz.crm.cps.external.barcode.sdk.service.ScanCodeRecordVoService;
import com.biz.crm.cps.external.barcode.sdk.utils.DesUtil;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeRecordChannelVo;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeRecordVo;
import com.biz.crm.cps.external.feign.service.CpsTjFeign;
import com.biz.crm.cps.external.feign.service.ERPMaintainOrgFeign;
import com.biz.crm.nebular.mdm.org.req.MdmOrgQueryVo;
import com.biz.crm.nebular.mdm.org.resp.MdmUserFindNameRespVo;
import com.biz.crm.nebular.tj.req.AgentScanEnterDto;
import com.biz.crm.nebular.tj.req.ScanCode;
import com.biz.crm.nebular.tj.res.AgentScanEnterVo;
import com.biz.crm.nebular.tj.res.TjResultVo;
import com.biz.crm.util.Result;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class ScanCodeRecordVoServiceImpl
implements ScanCodeRecordVoService {
    private static final Logger log = LoggerFactory.getLogger(ScanCodeRecordVoServiceImpl.class);
    @Autowired
    private ScanCodeRecordRepository scanCodeRecordRepository;
    @Autowired
    private ScanCodeRecordFactoryRepository scanCodeRecordFactoryRepository;
    @Autowired
    private ScanCodeChannelRepository scanCodeChannelRepository;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private BarCodeLatestCirculationRepository barCodeLatestCirculationRepository;
    @Autowired(required=false)
    private List<ScanCodeRecordEventListener> scanCodeRecordEventListeners;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired
    private BarCodeRepository barCodeRepository;
    @Autowired
    private DealerRepository dealerRepository;
    @Autowired
    private TerminalRepository terminalRepository;
    @Autowired
    private SupplyRelationshipRepository supplyRelationshipRepository;
    @Autowired
    private AgreementVoService agreementVoService;
    @Autowired
    private ScanCodeRecordVoRepository scanCodeRecordVoRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private List<ConsumerScanCodeRecordEventListener> consumerScanCodeRecordEventListeners;
    @Autowired
    private BarCodeConfig barCodeConfig;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private CpsTjFeign tjFeignClient;
    @Autowired
    private ERPMaintainOrgFeign erpMaintainOrgFeign;
    @Autowired
    private AgreementTemplateVoService agreementTemplateVoService;
    @Autowired
    private ConsumerScanProductMappingRepository consumerScanProductMappingRepository;
    @Value(value="${tianjian.appsecret:}")
    private String decryptKey;
    @Value(value="${tianjian.barCodeUrl:}")
    private String tjBarCodeUrl;

    public Integer countByScanCodeRecordDto(ScanCodeRecordStatisticsDto dto) {
        if (Objects.isNull(dto)) {
            return null;
        }
        return this.scanCodeRecordVoRepository.countByScanCodeRecordDto(dto);
    }

    public Page<ScanCodeRecordVo> findByConditions(ScanCodeRecordPageDto dto, Pageable pageable) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new ScanCodeRecordPageDto();
        }
        return this.scanCodeRecordVoRepository.findByConditions(dto, pageable);
    }

    public BigDecimal countSalesByScanCodeRecordPageDto(ScanCodeRecordPageDto dto) {
        BigDecimal countSales = BigDecimal.ZERO;
        String saleStandardUnit = this.barCodeConfig.getSaleStandardUnit();
        if (dto == null || StringUtils.isBlank((CharSequence)saleStandardUnit)) {
            return countSales;
        }
        List<ScanCodeRecordVo> list = this.scanCodeRecordVoRepository.findByConditions(dto);
        if (CollectionUtils.isEmpty(list)) {
            return countSales;
        }
        if (saleStandardUnit.equals(BarCodeTypeEnum.BOX.getKey())) {
            list.stream().forEach(scanCodeRecordVo -> countSales.add(scanCodeRecordVo.getStandardUnitBoxValue()));
        } else if (saleStandardUnit.equals(BarCodeTypeEnum.BOTTLE.getKey())) {
            list.stream().forEach(scanCodeRecordVo -> countSales.add(scanCodeRecordVo.getStandardUnitBottleValue()));
        }
        return countSales;
    }

    public ScanCodeRecordVo saveMcScanCodeRecord(ScanCodeRecordDto scanCodeRecordDto) {
        Validate.notNull((Object)scanCodeRecordDto, (String)"\u4f20\u5165\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeRecordDto.getConsumerScanCodeDto(), (String)"\u4f20\u5165\u7684\u6d88\u8d39\u8005\u626b\u7801\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return this.save(scanCodeRecordDto);
    }

    @Transactional
    public List<ScanCodeRecordChannelVo> updateScanCodeRecordChannel(ScanCodeRecordChannelDto dto) {
        ArrayList<ScanCodeRecordChannelVo> result = new ArrayList<ScanCodeRecordChannelVo>();
        if (CollectionUtils.isEmpty((Collection)dto.getRecordCodes())) {
            throw new IllegalArgumentException("\u66f4\u65b0\u64cd\u4f5c\u65f6\uff0c\u8bb0\u5f55\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.validateChannel(dto);
        dto.getRecordCodes().forEach(recordCode -> {
            ScanCodeRecord record = this.scanCodeRecordRepository.findByRecordCode((String)recordCode);
            if (Objects.isNull((Object)record)) {
                throw new IllegalArgumentException("\u672a\u627e\u5230\u76f8\u5173\u626b\u7801\u8bb0\u5f55\uff01");
            }
            record.setChannelCode(dto.getChannelCode());
            record.setChannelName(dto.getChannelName());
            record.setGroupBuyerInfo(dto.getGroupBuyerInfo());
            record.setGroupBuyerPhone(dto.getGroupBuyerPhone());
            this.scanCodeRecordRepository.saveOrUpdate((Object)record);
            ScanCodeRecordChannelVo channelVo = (ScanCodeRecordChannelVo)this.nebulaToolkitService.copyObjectByBlankList((Object)record, ScanCodeRecordChannelVo.class, Set.class, ArrayList.class, new String[0]);
            result.add(channelVo);
        });
        return result;
    }

    private void validateChannel(ScanCodeRecordChannelDto scanCodeRecordChannelDto) {
        Validate.notNull((Object)scanCodeRecordChannelDto, (String)"\u66f4\u65b0\u64cd\u4f5c\u65f6\uff0c\u4f20\u5165\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)scanCodeRecordChannelDto.getChannelCode(), (String)"\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)scanCodeRecordChannelDto.getChannelName(), (String)"\u6e20\u9053\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ScanCodeRecordVo dealerScanCode(ScanCodeRecordDto scanCodeRecordDto) {
        LoginUserDetails loginUserDetails = this.loginUserService.getLoginUser();
        if (Objects.isNull(loginUserDetails)) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u767b\u5f55\u4fe1\u606f\uff01");
        }
        this.createForm(scanCodeRecordDto);
        ScanCodeRecord record = this.scanCodeRecordRepository.findByBarCodeAndScanType(scanCodeRecordDto.getBarCode(), ScanTypeEnum.ENTER_WAREHOUSE.getCode(), scanCodeRecordDto.getParticipatorType());
        BarCode barCode = this.barCodeRepository.findByBarCode(scanCodeRecordDto.getBarCode());
        if (Objects.isNull((Object)barCode)) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u8bc6\u522b\u8be5\u7801\uff01");
        }
        if (!Objects.isNull((Object)record)) throw new IllegalArgumentException("\u8be5\u7bb1\u8d27\u7269\u5df2\u5165\u5e93");
        DealerEntity dealerEntity = this.dealerRepository.findByCustomerCode(loginUserDetails.getConsumerCode());
        if (Objects.isNull(dealerEntity)) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u767b\u5f55\u4fe1\u606f\uff01");
        }
        AgentScanEnterDto dto = new AgentScanEnterDto();
        dto.setAgent_code(dealerEntity.getErpCustomerCode());
        dto.setProvince(scanCodeRecordDto.getProvinceName());
        dto.setCity(scanCodeRecordDto.getCityName());
        dto.setCounty(scanCodeRecordDto.getDistrictName());
        dto.setAddress(scanCodeRecordDto.getAddress());
        ArrayList<Double> lnglat = new ArrayList<Double>();
        if (StringUtils.isNotBlank((CharSequence)scanCodeRecordDto.getLongitude()) && StringUtils.isNotBlank((CharSequence)scanCodeRecordDto.getLatitude())) {
            lnglat.add(Double.valueOf(scanCodeRecordDto.getLongitude()));
            lnglat.add(Double.valueOf(scanCodeRecordDto.getLatitude()));
        }
        dto.setLnglat(lnglat);
        ScanCode scanCode = new ScanCode();
        scanCode.setScan_tm(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        scanCode.setProduct_code(barCode.getProductCode());
        scanCode.setLabelcode(scanCodeRecordDto.getBarCode());
        ArrayList<ScanCode> scanCodes = new ArrayList<ScanCode>();
        scanCodes.add(scanCode);
        dto.setCodes(scanCodes);
        log.info("\u7ecf\u9500\u5546\u626b\u7801\u5165\u5e93-\u5929\u9274\u5165\u53c2={}", (Object)JSONArray.toJSONString((Object)dto));
        TjResultVo result = this.tjFeignClient.agentScanEnter(dto);
        log.info("\u7ecf\u9500\u5546\u626b\u7801\u5165\u5e93-\u5929\u9274\u8fd4\u56de={}", (Object)JSONArray.toJSONString((Object)result));
        if (!result.getSuccess().booleanValue()) throw new IllegalArgumentException("\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01");
        if (((AgentScanEnterVo)result.getData()).getEffectRows() <= 0) {
            throw new IllegalArgumentException("\u5165\u5e93\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01");
        }
        record = new ScanCodeRecord();
        this.createScanCodeRecordForm(record, scanCodeRecordDto);
        this.scanCodeRecordRepository.save((Object)record);
        return (ScanCodeRecordVo)this.nebulaToolkitService.copyObjectByBlankList((Object)record, ScanCodeRecordVo.class, Set.class, List.class, new String[0]);
    }

    private ScanCodeRecord createScanCodeRecordForm(ScanCodeRecord scanCodeRecord, ScanCodeRecordDto scanCodeRecordDto) {
        scanCodeRecord.setBarCode(scanCodeRecordDto.getBarCode());
        scanCodeRecord.setScanType(ScanTypeEnum.ENTER_WAREHOUSE.getCode());
        scanCodeRecord.setBarCodeParticipatorCode(scanCodeRecordDto.getBarCodeParticipatorCode());
        scanCodeRecord.setBarCodeType(BarCodeTypeEnum.BOX.getFlag());
        scanCodeRecord.setScanParticipatorCode(scanCodeRecordDto.getBarCodeParticipatorCode());
        scanCodeRecord.setEnterType(EnterTypeEnum.MANUAL.getCode());
        scanCodeRecord.setParticipatorType(scanCodeRecordDto.getParticipatorType());
        scanCodeRecord.setCreateTime(new Date());
        scanCodeRecord.setCreateAccount(this.loginUserService.getLoginAccountName());
        scanCodeRecord.setTenantCode(TenantUtils.getTenantCode());
        if (Objects.nonNull(this.generateCodeService)) {
            scanCodeRecord.setRecordCode((String)this.generateCodeService.generateCode("scanRecord", 1).get(0));
        } else {
            scanCodeRecord.setRecordCode(String.valueOf(System.currentTimeMillis()));
        }
        scanCodeRecord.setScanCodeException(ScanCodeExceptionEnum.NO.getCode());
        scanCodeRecord.setScanCodeJudge(ScanCodeJudgeEnum.NORMAL_IN.getCode());
        return scanCodeRecord;
    }

    public List<ScanCodeRecordVo> findByScanParticipatorCode(String scanParticipatorCode) {
        if (StringUtils.isBlank((CharSequence)scanParticipatorCode)) {
            return null;
        }
        return this.scanCodeRecordVoRepository.findByScanParticipatorCodeAndBarCode(scanParticipatorCode, null);
    }

    @Transactional
    public ScanCodeRecordVo create(ScanCodeRecordDto scanCodeRecordDto) {
        this.createForm(scanCodeRecordDto);
        if (ParticipatorTypeEnum.DEALER.getKey().equals(scanCodeRecordDto.getParticipatorType()) && ScanTypeEnum.OUT_WAREHOUSE.getCode().equals(scanCodeRecordDto.getScanType())) {
            this.dealerScanCodeValidate(scanCodeRecordDto);
        } else if (ParticipatorTypeEnum.TERMINAL.getKey().equals(scanCodeRecordDto.getParticipatorType())) {
            this.terminalScanCodeValidate(scanCodeRecordDto);
        } else if (ParticipatorTypeEnum.CONSUMER.getKey().equals(scanCodeRecordDto.getParticipatorType())) {
            this.consumerScanCodeValidate(scanCodeRecordDto);
        }
        return this.save(scanCodeRecordDto);
    }

    private void consumerScanCodeValidate(ScanCodeRecordDto scanCodeRecordDto) {
        scanCodeRecordDto.setScanCodeException(ScanCodeExceptionEnum.NO.getCode());
        String barCodeStr = this.splitBarCode(scanCodeRecordDto.getBarCode());
        if (StringUtils.isNotBlank((CharSequence)barCodeStr)) {
            scanCodeRecordDto.setBarCode(barCodeStr);
        } else {
            String barCodeStr2 = DesUtil.decryptDES((String)scanCodeRecordDto.getBarCode(), (String)this.decryptKey);
            scanCodeRecordDto.setBarCode(barCodeStr2);
        }
        BarCodeLatestCirculation latestCirculation = this.barCodeLatestCirculationRepository.findByBarCode(scanCodeRecordDto.getBarCode());
        if (Objects.nonNull((Object)latestCirculation)) {
            scanCodeRecordDto.setBarCodeParticipatorCode(latestCirculation.getBarCodeParticipatorCode());
        } else {
            scanCodeRecordDto.setBarCodeParticipatorCode(scanCodeRecordDto.getScanParticipatorCode());
        }
        BarCode barCode = this.barCodeRepository.findByBarCode(scanCodeRecordDto.getBarCode());
        if (Objects.isNull((Object)barCode)) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u8bc6\u522b\u8be5\u7801\uff01");
        }
        ConsumerScanProductMapping mapping = this.consumerScanProductMappingRepository.findByProduct(barCode.getProductCode());
        if (Objects.isNull((Object)mapping)) {
            throw new IllegalArgumentException("\u8be5\u4ea7\u54c1\u672a\u914d\u7f6e\u6d88\u8d39\u8005\u626b\u63cf\u7684\u7801\u7c7b\u578b\uff01");
        }
        if (!barCode.getBarCodeType().equals(mapping.getBarCodeType())) {
            throw new IllegalArgumentException("\u8bf7\u626b\u63cf" + BarCodeTypeEnum.getDesc((String)mapping.getBarCodeType()) + "\uff01");
        }
        ScanCodeRecord record = this.scanCodeRecordRepository.findByBarCode(scanCodeRecordDto.getBarCode(), ParticipatorTypeEnum.CONSUMER.getKey());
        if (Objects.nonNull((Object)record)) {
            throw new IllegalArgumentException("\u8be5\u4ea7\u54c1\u5df2\u53c2\u4e0e\u626b\u7801\uff01");
        }
        scanCodeRecordDto.setBarCodeType(barCode.getBarCodeType());
        scanCodeRecordDto.setProductCode(barCode.getProductCode());
        scanCodeRecordDto.setParentBarCode(barCode.getParentBarCode());
        AgreementTemplateVo templateVo = this.findTemplate(scanCodeRecordDto);
        if (Objects.nonNull(templateVo)) {
            HashSet templateCodes = Sets.newHashSet();
            templateCodes.add(templateVo.getTemplateCode());
            scanCodeRecordDto.setTemplateCodes((Set)templateCodes);
        }
    }

    public static void main(String[] args) {
        String str = "MiHw2HUxsDSgxjLnZB0H6Q==";
        String str2 = "http://tj1.me/?t=123456";
        String[] s = str.split("\\?t=");
        System.out.println(str.split("t=").length);
    }

    private AgreementTemplateVo findTemplate(ScanCodeRecordDto scanCodeRecordDto) {
        List list = this.agreementTemplateVoService.findByBarCode(scanCodeRecordDto.getBarCode());
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return (AgreementTemplateVo)list.get(0);
        }
        return null;
    }

    private void dealerScanCodeValidate(ScanCodeRecordDto scanCodeRecordDto) {
        String barCodeStr = this.splitBarCode(scanCodeRecordDto.getBarCode());
        if (!StringUtils.isNotBlank((CharSequence)barCodeStr)) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u8be5\u7801\uff01");
        }
        scanCodeRecordDto.setBarCode(barCodeStr);
        BarCode barCode = this.barCodeRepository.findByBarCode(scanCodeRecordDto.getBarCode());
        DealerEntity dealerEntity = this.dealerRepository.findByCustomerCodeAndEnable(scanCodeRecordDto.getScanParticipatorCode(), EnableStatusEnum.ENABLE.getCode());
        List<AgreementVo> agreementVos = this.findAgreementVos(scanCodeRecordDto);
        ScanCodeRecord record = this.scanCodeRecordRepository.findByBarCodeAndScanType(scanCodeRecordDto.getBarCode(), ScanTypeEnum.OUT_WAREHOUSE.getCode(), null);
        List<ScanCodeRecordFactory> factoryRecords = this.scanCodeRecordFactoryRepository.findByBarCode(scanCodeRecordDto.getBarCode());
        log.info("\u5382\u5546\u51fa\u5e93\u8bb0\u5f55={}", (Object)JSONObject.toJSONString(factoryRecords));
        ScanCodeRecordFactory factoryRecord = null;
        if (factoryRecords != null && factoryRecords.size() > 0) {
            factoryRecord = factoryRecords.get(0);
        }
        if (Objects.isNull((Object)barCode)) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u8bc6\u522b\u8be5\u7801\uff01");
        }
        scanCodeRecordDto.setBarCodeType(barCode.getBarCodeType());
        scanCodeRecordDto.setProductCode(barCode.getProductCode());
        scanCodeRecordDto.setParentBarCode(barCode.getParentBarCode());
        if (BarCodeTypeEnum.BOX.getFlag().equals(barCode.getBarCodeType())) {
            if (Objects.isNull((Object)record)) {
                if (scanCodeRecordDto.getScanParticipatorCode().equals(factoryRecord.getDealerCode())) {
                    boolean isConsumerScan = false;
                    if (isConsumerScan) {
                        scanCodeRecordDto.setScanCodeException(ScanCodeExceptionEnum.CROSS_OTHER_CONSUMER.getCode());
                        scanCodeRecordDto.setScanCodeExceptionMsg(ScanCodeExceptionEnum.CROSS_OTHER_CONSUMER.getDes());
                        scanCodeRecordDto.setScanCodeJudge(ScanCodeJudgeEnum.EXCEPTION_OUT.getCode());
                    } else {
                        ArrayList orgCodes = Lists.newArrayList();
                        for (DealerCommunicationEntity communication : dealerEntity.getDealerCommunications()) {
                            orgCodes.add(communication.getCommunicationOrgCode());
                        }
                        boolean isPosition = this.judgeLocation(scanCodeRecordDto, orgCodes);
                        if (isPosition) {
                            if (Objects.isNull(dealerEntity)) {
                                scanCodeRecordDto.setScanCodeException(ScanCodeExceptionEnum.NO_DEALER.getCode());
                                scanCodeRecordDto.setScanCodeExceptionMsg(ScanCodeExceptionEnum.NO_DEALER.getDes());
                                scanCodeRecordDto.setScanCodeJudge(ScanCodeJudgeEnum.NORMAL_OUT.getCode());
                            } else if (CollectionUtils.isEmpty(agreementVos)) {
                                scanCodeRecordDto.setScanCodeException(ScanCodeExceptionEnum.NO_AGREEMENT.getCode());
                                scanCodeRecordDto.setScanCodeExceptionMsg(ScanCodeExceptionEnum.NO_AGREEMENT.getDes());
                                scanCodeRecordDto.setScanCodeJudge(ScanCodeJudgeEnum.NORMAL_OUT.getCode());
                            } else {
                                HashSet templateCodes = Sets.newHashSet();
                                agreementVos.forEach(agreement -> templateCodes.add(agreement.getTemplateCode()));
                                scanCodeRecordDto.setTemplateCodes((Set)templateCodes);
                                scanCodeRecordDto.setScanCodeException(ScanCodeExceptionEnum.NO.getCode());
                                scanCodeRecordDto.setScanCodeExceptionMsg(ScanCodeExceptionEnum.NO.getDes());
                                scanCodeRecordDto.setScanCodeJudge(ScanCodeJudgeEnum.PROFIT_OUT.getCode());
                            }
                        } else {
                            scanCodeRecordDto.setScanCodeException(ScanCodeExceptionEnum.CROSS_POSITION.getCode());
                            scanCodeRecordDto.setScanCodeExceptionMsg(ScanCodeExceptionEnum.CROSS_POSITION.getDes());
                            scanCodeRecordDto.setScanCodeJudge(ScanCodeJudgeEnum.EXCEPTION_OUT.getCode());
                        }
                    }
                } else {
                    scanCodeRecordDto.setScanCodeException(ScanCodeExceptionEnum.CROSS_DEALER_FACTORY.getCode());
                    scanCodeRecordDto.setScanCodeExceptionMsg(ScanCodeExceptionEnum.CROSS_DEALER_FACTORY.getDes());
                    scanCodeRecordDto.setScanCodeJudge(ScanCodeJudgeEnum.EXCEPTION_OUT.getCode());
                }
            } else {
                if (scanCodeRecordDto.getScanParticipatorCode().equals(record.getScanParticipatorCode())) {
                    throw new IllegalArgumentException("\u8be5\u8d27\u7269\u5df2\u51fa\u5e93\uff01");
                }
                scanCodeRecordDto.setScanCodeException(ScanCodeExceptionEnum.CROSS_OTHERS.getCode());
                scanCodeRecordDto.setScanCodeExceptionMsg(ScanCodeExceptionEnum.CROSS_OTHERS.getDes());
                scanCodeRecordDto.setScanCodeJudge(ScanCodeJudgeEnum.EXCEPTION_OUT.getCode());
            }
        } else {
            throw new IllegalArgumentException("\u8bf7\u626b\u63cf\u7bb1\u7801\uff01");
        }
    }

    private String splitBarCode(String barCode) {
        if (StringUtils.isNotBlank((CharSequence)barCode)) {
            String[] str = barCode.split("\\?t=");
            if (str.length == 2) {
                return str[1];
            }
            return null;
        }
        return null;
    }

    private boolean judgeLocation(ScanCodeRecordDto scanCodeRecordDto, List<String> orgCodes) {
        MdmOrgQueryVo orgReq = new MdmOrgQueryVo();
        orgReq.setProvinceName(scanCodeRecordDto.getProvinceName());
        orgReq.setCityName(scanCodeRecordDto.getCityName());
        log.info("mdm\u6839\u636e\u7701\u5e02\u67e5\u8be2\u7ec4\u7ec7\u67b6\u6784\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)orgReq));
        Result orgResult = this.erpMaintainOrgFeign.findOrgByProvinceAndCity(orgReq);
        log.info("mdm\u6839\u636e\u7701\u5e02\u67e5\u8be2\u7ec4\u7ec7\u67b6\u6784\u8fd4\u56de={}", (Object)JSONObject.toJSONString((Object)orgResult));
        if (Objects.nonNull(orgResult)) {
            if (!CollectionUtils.isEmpty((Collection)((Collection)orgResult.getResult()))) {
                for (MdmUserFindNameRespVo res : (List)orgResult.getResult()) {
                    for (String org : orgCodes) {
                        if (!org.equals(res.getOrgCode())) continue;
                        return true;
                    }
                }
            } else {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void terminalScanCodeValidate(ScanCodeRecordDto scanCodeRecordDto) {
        String barCodeStr = this.splitBarCode(scanCodeRecordDto.getBarCode());
        if (!StringUtils.isNotBlank((CharSequence)barCodeStr)) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u8be5\u7801\uff01");
        }
        scanCodeRecordDto.setBarCode(barCodeStr);
        BarCode barCode = this.barCodeRepository.findByBarCode(scanCodeRecordDto.getBarCode());
        Terminal terminal = this.terminalRepository.findByTerminalCode(scanCodeRecordDto.getScanParticipatorCode());
        List<AgreementVo> agreementVos = this.findAgreementVos(scanCodeRecordDto);
        ScanCodeRecord terminalRecord = this.scanCodeRecordRepository.findByBarCodeAndScanType(scanCodeRecordDto.getBarCode(), ScanTypeEnum.ENTER_WAREHOUSE.getCode(), ParticipatorTypeEnum.TERMINAL.getKey());
        ScanCodeRecord dealerRecord = this.scanCodeRecordRepository.findByBarCodeAndScanType(scanCodeRecordDto.getBarCode(), ScanTypeEnum.OUT_WAREHOUSE.getCode(), ParticipatorTypeEnum.DEALER.getKey());
        List<ScanCodeRecordFactory> factoryRecords = this.scanCodeRecordFactoryRepository.findByBarCode(scanCodeRecordDto.getBarCode());
        ScanCodeRecordFactory factoryRecord = null;
        if (factoryRecords != null && factoryRecords.size() > 0) {
            factoryRecord = factoryRecords.get(0);
        }
        int count = this.scanCodeRecordRepository.findRangeCountByBarCode(scanCodeRecordDto.getBarCode());
        List supplyRelationships = this.supplyRelationshipRepository.findByTerminalCode(scanCodeRecordDto.getScanParticipatorCode());
        if (!Objects.nonNull((Object)barCode)) throw new IllegalArgumentException("\u65e0\u6cd5\u8bc6\u522b\u8be5\u7801\uff01");
        scanCodeRecordDto.setBarCodeType(barCode.getBarCodeType());
        scanCodeRecordDto.setProductCode(barCode.getProductCode());
        scanCodeRecordDto.setParentBarCode(barCode.getParentBarCode());
        if (count <= 0) throw new IllegalArgumentException("\u8be5\u4ea7\u54c1\u672a\u53c2\u4e0e\u5206\u5229\uff01");
        if (!BarCodeTypeEnum.BOX.getFlag().equals(barCode.getBarCodeType())) throw new IllegalArgumentException("\u8bf7\u626b\u63cf\u7bb1\u7801\uff01");
        if (Objects.nonNull((Object)terminalRecord)) {
            if (scanCodeRecordDto.getScanParticipatorCode().equals(terminalRecord.getScanParticipatorCode())) {
                throw new IllegalArgumentException("\u8be5\u8d27\u7269\u5df2\u5165\u5e93\uff01");
            }
            scanCodeRecordDto.setScanCodeException(ScanCodeExceptionEnum.CROSS_OTHER_TERMINAL.getCode());
            scanCodeRecordDto.setScanCodeExceptionMsg(ScanCodeExceptionEnum.CROSS_OTHER_TERMINAL.getDes());
            scanCodeRecordDto.setScanCodeJudge(ScanCodeJudgeEnum.EXCEPTION_IN.getCode());
            return;
        }
        if (Objects.nonNull((Object)dealerRecord)) {
            if (!ScanCodeJudgeEnum.EXCEPTION_OUT.getCode().equals(dealerRecord.getScanCodeJudge())) {
                if (!CollectionUtils.isEmpty((Collection)supplyRelationships)) {
                    ArrayList orgCodes = Lists.newArrayList();
                    String dealerCode = dealerRecord.getScanParticipatorCode();
                    AtomicBoolean dealerAndTerminal = new AtomicBoolean(false);
                    for (SupplyRelationship supplyRelationship : supplyRelationships) {
                        orgCodes.add(supplyRelationship.getSalesmanOrganizationCode());
                        if (!dealerCode.equals(supplyRelationship.getExternalIdentifier())) continue;
                        List supplyRelationshipDetails = supplyRelationship.getDetails();
                        if (!CollectionUtils.isEmpty((Collection)supplyRelationshipDetails)) {
                            for (SupplyRelationshipDetail supplyRelationshipDetail : supplyRelationshipDetails) {
                                int counts = this.barCodeRepository.findByBarCodeAndProductCode(scanCodeRecordDto.getBarCode(), supplyRelationshipDetail.getCode());
                                if (counts <= 0) continue;
                                dealerAndTerminal.set(true);
                            }
                            continue;
                        }
                        scanCodeRecordDto.setScanCodeException(ScanCodeExceptionEnum.NO_SUPPLYRELATIONSHIP.getCode());
                        scanCodeRecordDto.setScanCodeExceptionMsg(ScanCodeExceptionEnum.NO_SUPPLYRELATIONSHIP.getDes());
                        scanCodeRecordDto.setScanCodeJudge(ScanCodeJudgeEnum.EXCEPTION_IN.getCode());
                    }
                    if (dealerAndTerminal.get()) {
                        boolean consumer = false;
                        if (consumer) {
                            scanCodeRecordDto.setScanCodeException(ScanCodeExceptionEnum.CROSS_OTHER_CONSUMER.getCode());
                            scanCodeRecordDto.setScanCodeExceptionMsg(ScanCodeExceptionEnum.CROSS_OTHER_CONSUMER.getDes());
                            scanCodeRecordDto.setScanCodeJudge(ScanCodeJudgeEnum.EXCEPTION_IN.getCode());
                            return;
                        } else {
                            boolean position = this.judgeLocation(scanCodeRecordDto, orgCodes);
                            if (position) {
                                if (!CollectionUtils.isEmpty(agreementVos)) {
                                    scanCodeRecordDto.setScanCodeException(ScanCodeExceptionEnum.NO.getCode());
                                    scanCodeRecordDto.setScanCodeExceptionMsg(ScanCodeExceptionEnum.NO.getDes());
                                    scanCodeRecordDto.setScanCodeJudge(ScanCodeJudgeEnum.PROFIT_IN.getCode());
                                    HashSet templateCodes = Sets.newHashSet();
                                    agreementVos.forEach(agreement -> templateCodes.add(agreement.getTemplateCode()));
                                    scanCodeRecordDto.setTemplateCodes((Set)templateCodes);
                                    return;
                                } else {
                                    scanCodeRecordDto.setScanCodeException(ScanCodeExceptionEnum.NO_AGREEMENT.getCode());
                                    scanCodeRecordDto.setScanCodeExceptionMsg(ScanCodeExceptionEnum.NO_AGREEMENT.getDes());
                                    scanCodeRecordDto.setScanCodeJudge(ScanCodeJudgeEnum.NORMAL_IN.getCode());
                                }
                                return;
                            } else {
                                scanCodeRecordDto.setScanCodeException(ScanCodeExceptionEnum.CROSS_POSITION.getCode());
                                scanCodeRecordDto.setScanCodeExceptionMsg(ScanCodeExceptionEnum.CROSS_POSITION.getDes());
                                scanCodeRecordDto.setScanCodeJudge(ScanCodeJudgeEnum.EXCEPTION_IN.getCode());
                            }
                        }
                        return;
                    } else {
                        scanCodeRecordDto.setScanCodeException(ScanCodeExceptionEnum.CROSS_TERMINAL_DEALER.getCode());
                        scanCodeRecordDto.setScanCodeExceptionMsg(ScanCodeExceptionEnum.CROSS_TERMINAL_DEALER.getDes());
                        scanCodeRecordDto.setScanCodeJudge(ScanCodeJudgeEnum.EXCEPTION_IN.getCode());
                    }
                    return;
                }
                scanCodeRecordDto.setScanCodeException(ScanCodeExceptionEnum.NO_SUPPLYRELATIONSHIP.getCode());
                scanCodeRecordDto.setScanCodeExceptionMsg(ScanCodeExceptionEnum.NO_SUPPLYRELATIONSHIP.getDes());
                scanCodeRecordDto.setScanCodeJudge(ScanCodeJudgeEnum.EXCEPTION_IN.getCode());
                return;
            }
            scanCodeRecordDto.setScanCodeException(ScanCodeExceptionEnum.ERROE_OUT_FOR_DEALER.getCode());
            scanCodeRecordDto.setScanCodeExceptionMsg(ScanCodeExceptionEnum.ERROE_OUT_FOR_DEALER.getDes());
            scanCodeRecordDto.setScanCodeJudge(ScanCodeJudgeEnum.EXCEPTION_IN.getCode());
            return;
        }
        scanCodeRecordDto.setScanCodeException(ScanCodeExceptionEnum.ERROE_OUT_FOR_DEALER.getCode());
        scanCodeRecordDto.setScanCodeExceptionMsg(ScanCodeExceptionEnum.ERROE_OUT_FOR_DEALER.getDes());
        scanCodeRecordDto.setScanCodeJudge(ScanCodeJudgeEnum.EXCEPTION_IN.getCode());
    }

    private List<AgreementVo> findAgreementVos(ScanCodeRecordDto scanCodeRecordDto) {
        Validate.notNull((Object)scanCodeRecordDto, (String)"\u626b\u7801\u8bb0\u5f55\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        LoginUserAgreementDto loginUserAgreementDto = new LoginUserAgreementDto();
        if (BarCodeTypeEnum.COVER_CODE.getFlag().equals(scanCodeRecordDto.getBarCodeType())) {
            ConsumerScanCodeDto consumerScanCodeDto = scanCodeRecordDto.getConsumerScanCodeDto();
            this.buildLoginUserAgreementDto(consumerScanCodeDto.getBarCodeParticipatorCode(), consumerScanCodeDto.getParticipatorType(), loginUserAgreementDto);
        } else {
            this.buildLoginUserAgreementDto(scanCodeRecordDto.getScanParticipatorCode(), scanCodeRecordDto.getParticipatorType(), loginUserAgreementDto);
        }
        loginUserAgreementDto.setBarCode(scanCodeRecordDto.getBarCode());
        List agreementVos = this.agreementVoService.findByConditions(loginUserAgreementDto);
        return agreementVos;
    }

    private void buildLoginUserAgreementDto(String scanParticipatorCode, String participatorType, LoginUserAgreementDto loginUserAgreementDto) {
        if (ParticipatorTypeEnum.TERMINAL.getKey().equals(participatorType)) {
            loginUserAgreementDto.setTerminalCode(scanParticipatorCode);
        } else if (ParticipatorTypeEnum.DEALER.getKey().equals(participatorType)) {
            loginUserAgreementDto.setCustomerCode(scanParticipatorCode);
        }
        loginUserAgreementDto.setAgreementStatus(AgreementStatusEnum.EXECUTING.getCode());
        loginUserAgreementDto.setSignStatus(SignStatusEnum.SIGNED.getCode());
    }

    @Transactional
    public ScanCodeRecordVo save(ScanCodeRecordDto scanCodeRecordDto) {
        ScanCodeRecord scanCodeRecord = (ScanCodeRecord)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)scanCodeRecordDto, ScanCodeRecord.class, HashSet.class, ArrayList.class, new String[0]));
        scanCodeRecord.setCreateTime(new Date());
        if (ScanCodeExceptionEnum.NO.getCode().equals(scanCodeRecord.getScanCodeException())) {
            scanCodeRecord.setBarCodeParticipatorCode(scanCodeRecordDto.getScanParticipatorCode());
        }
        scanCodeRecord.setCreateAccount(this.loginUserService.getLoginAccountName());
        scanCodeRecord.setTenantCode(TenantUtils.getTenantCode());
        if (Objects.nonNull(this.generateCodeService)) {
            scanCodeRecord.setRecordCode((String)this.generateCodeService.generateCode("scanRecord", 1).get(0));
        } else {
            scanCodeRecord.setRecordCode(String.valueOf(System.currentTimeMillis()));
        }
        this.scanCodeRecordRepository.save((Object)scanCodeRecord);
        if (ParticipatorTypeEnum.DEALER.getKey().equals(scanCodeRecord.getParticipatorType()) && ScanTypeEnum.OUT_WAREHOUSE.getCode().equals(scanCodeRecord.getScanType()) && scanCodeRecordDto.getScanCodeChannelVo() != null) {
            ScanCodeChannel scanCodeChannel = (ScanCodeChannel)this.nebulaToolkitService.copyObjectByBlankList((Object)scanCodeRecordDto.getScanCodeChannelVo(), ScanCodeChannel.class, HashSet.class, null, new String[0]);
            this.scanCodeChannelRepository.save(scanCodeChannel);
        }
        if (ScanCodeExceptionEnum.NO.getCode().equals(scanCodeRecord.getScanCodeException()) && (ScanCodeJudgeEnum.PROFIT_OUT.getCode().equals(scanCodeRecord.getScanCodeJudge()) || ScanCodeJudgeEnum.PROFIT_IN.getCode().equals(scanCodeRecord.getScanCodeJudge()))) {
            List<BarCodeLatestCirculation> list = this.createBarCodeLatestCirculationFrom(scanCodeRecord, scanCodeRecordDto);
            this.barCodeLatestCirculationRepository.saveOrUpdateBatch(list);
        }
        ScanCodeRecordEventDto scanCodeRecordEventDto = (ScanCodeRecordEventDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)scanCodeRecordDto, ScanCodeRecordEventDto.class, HashSet.class, ArrayList.class, new String[]{"templateCodes"});
        scanCodeRecordEventDto.setRecordCode(scanCodeRecord.getRecordCode());
        this.notifyEvents(scanCodeRecordEventDto, scanCodeRecordDto);
        return (ScanCodeRecordVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)scanCodeRecord, ScanCodeRecordVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private List<BarCodeLatestCirculation> createBarCodeLatestCirculationFrom(ScanCodeRecord scanCodeRecord, ScanCodeRecordDto scanCodeRecordDto) {
        ArrayList<BarCodeLatestCirculation> list = new ArrayList<BarCodeLatestCirculation>();
        List<Object> barCodes = new ArrayList();
        if (BarCodeTypeEnum.BOX.getFlag().equals(scanCodeRecord.getBarCodeType())) {
            barCodes = this.barCodeRepository.findByParentBarCode(scanCodeRecord.getBarCode());
        }
        if (BarCodeTypeEnum.BOTTLE.getFlag().equals(scanCodeRecord.getBarCodeType())) {
            BarCode barCode2 = this.barCodeRepository.findByBarCode(scanCodeRecordDto.getParentBarCode());
            barCodes.add((Object)barCode2);
        }
        if (!CollectionUtils.isEmpty(barCodes)) {
            List<String> codes = barCodes.stream().map(BarCode::getBarCode).collect(Collectors.toList());
            List<BarCodeLatestCirculation> barCodeLatestCirculations = this.barCodeLatestCirculationRepository.findByBarCodes(codes);
            Map<String, String> map = barCodeLatestCirculations.stream().collect(Collectors.toMap(BarCodeLatestCirculation::getBarCode, BaseIdEntity::getId));
            barCodes.stream().forEach(barCode -> {
                BarCodeLatestCirculation barCodeLatest = (BarCodeLatestCirculation)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)scanCodeRecord, BarCodeLatestCirculation.class, HashSet.class, ArrayList.class, new String[0])));
                barCodeLatest.setId(null);
                String id = (String)map.get(barCode.getBarCode());
                if (StringUtils.isNotBlank((CharSequence)id)) {
                    barCodeLatest.setId(id);
                }
                if (BarCodeTypeEnum.BOX.getFlag().equals(barCode.getBarCodeType())) {
                    barCodeLatest.setScanCodeException(ScanCodeExceptionEnum.BOTTLE.getCode());
                }
                if (BarCodeTypeEnum.BOTTLE.getFlag().equals(barCode.getBarCodeType())) {
                    barCodeLatest.setScanCodeException(ScanCodeExceptionEnum.BOX.getCode());
                }
                barCodeLatest.setBarCode(barCode.getBarCode());
                barCodeLatest.setBarCodeType(barCode.getBarCodeType());
                list.add(barCodeLatest);
            });
        }
        BarCodeLatestCirculation barCodeLatestCirculation = (BarCodeLatestCirculation)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)scanCodeRecord, BarCodeLatestCirculation.class, HashSet.class, ArrayList.class, new String[0]));
        BarCodeLatestCirculation latestCirculation = this.barCodeLatestCirculationRepository.findByBarCode(scanCodeRecord.getBarCode());
        barCodeLatestCirculation.setId(null);
        if (latestCirculation != null) {
            barCodeLatestCirculation.setId(latestCirculation.getId());
        }
        list.add(barCodeLatestCirculation);
        return list;
    }

    private void createForm(ScanCodeRecordDto scanCodeRecordDto) {
        this.createValidation(scanCodeRecordDto);
        LoginUserDetails loginUser = this.loginUserService.getLoginUser();
        String scanParticipatorCode = null;
        String participatorType = null;
        if (Objects.nonNull(loginUser)) {
            scanParticipatorCode = loginUser.getConsumerCode();
            participatorType = loginUser.getUsertype();
        } else {
            this.createConsumerValidation(scanCodeRecordDto);
            scanParticipatorCode = scanCodeRecordDto.getConsumerScanCodeDto().getExternalId();
            participatorType = "consumer";
        }
        Validate.notNull((Object)scanParticipatorCode, (String)"\u5f53\u524d\u53c2\u4e0e\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)participatorType, (String)"\u5f53\u524d\u53c2\u4e0e\u8005\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        scanCodeRecordDto.setScanParticipatorCode(scanParticipatorCode);
        scanCodeRecordDto.setBarCodeParticipatorCode(scanParticipatorCode);
        scanCodeRecordDto.setParticipatorType(participatorType);
    }

    private BarCodeDto findByExternalUrl(String barCode) {
        String externalUrl = this.barCodeConfig.getExternalUrl();
        if (StringUtils.isBlank((CharSequence)externalUrl)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("barCode", barCode);
        BarCodeDto barCodeDto = (BarCodeDto)this.restTemplate.postForObject(externalUrl, map, BarCodeDto.class, new Object[0]);
        if (barCode == null) {
            return null;
        }
        return barCodeDto;
    }

    private void createConsumerValidation(ScanCodeRecordDto dto) {
        ConsumerScanCodeDto consumerScanCodeDto = dto.getConsumerScanCodeDto();
        Validate.notNull((Object)consumerScanCodeDto, (String)"\u6d88\u8d39\u8005\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)consumerScanCodeDto.getExternalId(), (String)"\u6d88\u8d39\u8005\u5916\u90e8id\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)consumerScanCodeDto.getPhone(), (String)"\u6d88\u8d39\u8005\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)consumerScanCodeDto.getNickname(), (String)"\u6d88\u8d39\u8005\u6635\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void createValidation(ScanCodeRecordDto dto) {
        Validate.notNull((Object)dto, (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u65b0\u589e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBarCode(), (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u6761\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getEnterType(), (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u5f55\u5165\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getScanType(), (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u626b\u7801\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private ConsumerScanCodeDto createConsumerScanCodeDtoForm(String parentBarCode, ConsumerScanCodeDto consumerScanCodeDto) {
        BarCodeLatestCirculation barCodeLatestCirculation = this.barCodeLatestCirculationRepository.findByBarCode(parentBarCode);
        Validate.notNull((Object)((Object)barCodeLatestCirculation), (String)"\u626b\u76d6\u5185\u7801\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u7236\u7ea7\u76d2\u7801\u7684\u6700\u65b0\u6d41\u8f6c\u4eba\uff01", (Object[])new Object[0]);
        consumerScanCodeDto.setNickname(this.loginUserService.getLoginUser().getConsumerName());
        consumerScanCodeDto.setParticipatorType(barCodeLatestCirculation.getParticipatorType());
        consumerScanCodeDto.setBarCodeParticipatorCode(barCodeLatestCirculation.getBarCodeParticipatorCode());
        return consumerScanCodeDto;
    }

    private void notifyEvents(ScanCodeRecordEventDto scanCodeRecordEventDto, ScanCodeRecordDto scanCodeRecordDto) {
        if (Objects.isNull(scanCodeRecordEventDto) || Objects.isNull(scanCodeRecordDto)) {
            return;
        }
        scanCodeRecordEventDto.setTemplateCodes(scanCodeRecordDto.getTemplateCodes());
        scanCodeRecordEventDto.setProductCode(scanCodeRecordDto.getProductCode());
        if ("consumer".equals(scanCodeRecordEventDto.getParticipatorType()) && !CollectionUtils.isEmpty(this.consumerScanCodeRecordEventListeners)) {
            if (scanCodeRecordDto.getBarCodeParticipatorCode() == null) {
                ConsumerScanCodeDto consumerScanCodeDtoForm = this.createConsumerScanCodeDtoForm(scanCodeRecordDto.getParentBarCode(), scanCodeRecordDto.getConsumerScanCodeDto());
                scanCodeRecordEventDto.setConsumerScanCodeDto(consumerScanCodeDtoForm);
            } else {
                scanCodeRecordEventDto.setConsumerScanCodeDto(scanCodeRecordDto.getConsumerScanCodeDto());
            }
            for (ConsumerScanCodeRecordEventListener consumerScanCodeRecordEventListener : this.consumerScanCodeRecordEventListeners) {
                if (ScanCodeExceptionEnum.NO.getCode().equals(scanCodeRecordDto.getScanCodeException())) {
                    consumerScanCodeRecordEventListener.onSuccessScan(scanCodeRecordEventDto);
                    continue;
                }
                consumerScanCodeRecordEventListener.onFailScan(scanCodeRecordEventDto);
            }
        }
        if (!CollectionUtils.isEmpty(this.scanCodeRecordEventListeners)) {
            for (ScanCodeRecordEventListener scanCodeRecordEventListener : this.scanCodeRecordEventListeners) {
                if ("consumer".equals(scanCodeRecordEventDto.getParticipatorType())) {
                    if (ScanCodeExceptionEnum.NO.getCode().equals(scanCodeRecordDto.getScanCodeException())) {
                        scanCodeRecordEventListener.onSuccessScan(scanCodeRecordEventDto);
                        continue;
                    }
                    scanCodeRecordEventListener.onFailScan(scanCodeRecordEventDto);
                    continue;
                }
                if (ScanCodeExceptionEnum.NO.getCode().equals(scanCodeRecordDto.getScanCodeException()) && (ScanCodeJudgeEnum.PROFIT_OUT.getCode().equals(scanCodeRecordDto.getScanCodeJudge()) || ScanCodeJudgeEnum.PROFIT_IN.getCode().equals(scanCodeRecordDto.getScanCodeJudge()))) {
                    scanCodeRecordEventListener.onSuccessScan(scanCodeRecordEventDto);
                    continue;
                }
                scanCodeRecordEventListener.onFailScan(scanCodeRecordEventDto);
            }
        }
        if (ScanCodeExceptionEnum.NO.getCode().equals(scanCodeRecordDto.getScanCodeException())) {
            // empty if block
        }
    }

    private void scanSuccessCallback(String barCode) {
        String scanSuccessCallbackUrl = this.barCodeConfig.getScanSuccessCallbackUrlList();
        if (StringUtils.isBlank((CharSequence)scanSuccessCallbackUrl)) {
            return;
        }
        List<ScanCodeRecordVo> byScanParticipatorCodeAndBarCode = this.scanCodeRecordVoRepository.findByScanParticipatorCodeAndBarCode(this.loginUserService.getLoginUser().getConsumerCode(), barCode);
        if (CollectionUtils.isEmpty(byScanParticipatorCodeAndBarCode)) {
            return;
        }
        ScanCodeRecordVo scanCodeRecordVo = byScanParticipatorCodeAndBarCode.get(0);
        if (Objects.isNull(scanCodeRecordVo)) {
            return;
        }
        try {
            String[] split = scanSuccessCallbackUrl.split(";");
            for (int i = 0; i < split.length; ++i) {
                this.restTemplate.postForObject(split[i], (Object)scanCodeRecordVo, null, new Object[0]);
            }
        }
        catch (RuntimeException e) {
            log.warn("\u56de\u8c03\u5916\u90e8\u7cfb\u7edf\u9519\u8bef\uff01");
        }
    }
}

