/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.barcode.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.business.participator.local.repository.TerminalRepository;
import com.biz.crm.cps.external.barcode.local.repository.ScanCodeRecordRepository;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeJudgeEnum;
import com.biz.crm.cps.external.barcode.sdk.service.TjScanCodeRecordService;
import com.biz.crm.cps.external.barcode.sdk.vo.DealerScanCodeRecordVo;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeRecordVo;
import com.biz.crm.cps.external.barcode.sdk.vo.TerminalScanCodeRecordVo;
import com.biz.crm.cps.external.feign.service.CpsTjFeign;
import com.biz.crm.nebular.tj.req.PushAgentScandataDto;
import com.biz.crm.nebular.tj.req.PushTerminalScandataDto;
import com.biz.crm.nebular.tj.req.ScanCode;
import com.biz.crm.nebular.tj.res.TjResultVo;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class TjScanCodeRecordServiceImpl
implements TjScanCodeRecordService {
    private static final Logger log = LoggerFactory.getLogger(TjScanCodeRecordServiceImpl.class);
    @Autowired
    private CpsTjFeign tjFeignClient;
    @Autowired
    private ScanCodeRecordRepository scanCodeRecordRepository;
    @Autowired
    private TerminalRepository terminalRepository;

    @Transactional
    public boolean pushTerminalScanCodeToTj() {
        Map<String, Date> map = this.getTimeByCalender();
        List<TerminalScanCodeRecordVo> terminals = this.scanCodeRecordRepository.findTerminalScanCodeRecordByDate(map.get("startTime"), map.get("endTime"));
        log.info(new Date().toString() + ",\u7ec8\u7aef\u5165\u5e93\u626b\u7801\u6570\u636e\u63a8\u9001\u5929\u9274={}", (Object)JSONObject.toJSONString(terminals));
        if (!CollectionUtils.isEmpty(terminals)) {
            ArrayList<ScanCodeRecordVo> failRecord = new ArrayList<ScanCodeRecordVo>();
            for (TerminalScanCodeRecordVo terminal : terminals) {
                PushTerminalScandataDto dto = new PushTerminalScandataDto();
                dto.setAddress(terminal.getTerminalAddress());
                dto.setProvince(terminal.getProvinceName());
                dto.setCity(terminal.getCityName());
                dto.setCounty(terminal.getDistrictName());
                dto.setTerminalId(terminal.getTjTerminalId());
                ArrayList<String> lnglat = new ArrayList<String>();
                lnglat.add(terminal.getLongitude());
                lnglat.add(terminal.getLatitude());
                dto.setLnglat(lnglat);
                ArrayList<ScanCode> scanCodes = new ArrayList<ScanCode>();
                if (!CollectionUtils.isEmpty((Collection)terminal.getScanCodeRecords())) {
                    for (ScanCodeRecordVo vo : terminal.getScanCodeRecords()) {
                        ScanCode scanCode = new ScanCode();
                        scanCode.setLabelcode(vo.getBarCode());
                        scanCode.setProduct_code(vo.getProductCode());
                        scanCode.setScan_tm(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(vo.getCreateTime()));
                        scanCodes.add(scanCode);
                    }
                }
                dto.setCodes(scanCodes);
                log.info("\u7ec8\u7aef\u5165\u5e93\u626b\u7801\u6570\u636e\u63a8\u9001\u5929\u9274\u5165\u53c2={}", JSONObject.toJSON((Object)dto));
                TjResultVo result = this.tjFeignClient.pushTerminalScandata(dto);
                log.info("\u7ec8\u7aef\u5165\u5e93\u626b\u7801\u6570\u636e\u63a8\u9001\u5929\u9274\u8fd4\u56de={}", JSONObject.toJSON((Object)result));
                if (!Objects.isNull(result) && result.getSuccess().booleanValue()) continue;
                failRecord.addAll(terminal.getScanCodeRecords());
            }
            if (!CollectionUtils.isEmpty(failRecord)) {
                this.scanCodeRecordRepository.updateTjSendStatus(failRecord);
            }
        }
        return false;
    }

    public boolean pushDealerScanCodeToTj() {
        Map<String, Date> map = this.getTimeByCalender();
        ArrayList list = Lists.newArrayList();
        list.add(ScanCodeJudgeEnum.NORMAL_OUT.getCode());
        list.add(ScanCodeJudgeEnum.PROFIT_OUT.getCode());
        List<DealerScanCodeRecordVo> dealers = this.scanCodeRecordRepository.findDealerScanCodeRecordRecordByDate(map.get("startTime"), map.get("endTime"), list);
        log.info(new Date().toString() + ",\u7ecf\u9500\u5546\u51fa\u5e93\u626b\u7801\u6570\u636e\u63a8\u9001\u5929\u9274={}", (Object)JSONObject.toJSONString(dealers));
        if (!CollectionUtils.isEmpty(dealers)) {
            ArrayList<ScanCodeRecordVo> failRecord = new ArrayList<ScanCodeRecordVo>();
            for (DealerScanCodeRecordVo dealer : dealers) {
                PushAgentScandataDto dto = new PushAgentScandataDto();
                dto.setAddress(dealer.getDealerAddress());
                dto.setProvince(dealer.getProvinceName());
                dto.setCity(dealer.getCityName());
                dto.setCounty(dealer.getDistrictName());
                dto.setAgentCode(dealer.getDealerCodeErp());
                ArrayList<String> lnglat = new ArrayList<String>();
                lnglat.add(dealer.getLongitude());
                lnglat.add(dealer.getLatitude());
                dto.setLnglat(lnglat);
                ArrayList<ScanCode> scanCodes = new ArrayList<ScanCode>();
                if (!CollectionUtils.isEmpty((Collection)dealer.getScanCodeRecords())) {
                    for (ScanCodeRecordVo vo : dealer.getScanCodeRecords()) {
                        ScanCode scanCode = new ScanCode();
                        scanCode.setLabelcode(vo.getBarCode());
                        scanCode.setProduct_code(vo.getProductCode());
                        scanCode.setScan_tm(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(vo.getCreateTime()));
                        scanCodes.add(scanCode);
                    }
                }
                dto.setCodes(scanCodes);
                TjResultVo result = this.tjFeignClient.pushAgentScandata(dto);
                log.info("\u7ecf\u9500\u5546\u626b\u7801\u51fa\u5e93\u6570\u636e\u63a8\u9001\u5929\u9274\u8fd4\u56de={}", JSONObject.toJSON((Object)result));
                if (!Objects.isNull(result) && result.getSuccess().booleanValue()) continue;
                failRecord.addAll(dealer.getScanCodeRecords());
            }
            if (!CollectionUtils.isEmpty(failRecord)) {
                this.scanCodeRecordRepository.updateTjSendStatus(failRecord);
            }
        }
        return false;
    }

    public Map<String, Date> getTimeByCalender() {
        Hashtable<String, Date> map = new Hashtable<String, Date>();
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date startTime = calendar.getTime();
        map.put("startTime", startTime);
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        Date endTime = calendar.getTime();
        map.put("endTime", endTime);
        return map;
    }
}

