/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.barcode.local.service.notifier;

import com.biz.crm.cps.external.barcode.local.entity.BarCodeLatestCirculation;
import com.biz.crm.cps.external.barcode.local.entity.ScanCodeRecord;
import com.biz.crm.cps.external.barcode.local.service.BarCodeLatestCirculationService;
import com.biz.crm.cps.external.barcode.local.service.ScanCodeRecordService;
import com.biz.crm.cps.external.barcode.sdk.common.enums.BarCodeTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeExceptionStrategyDto;
import com.biz.crm.cps.external.barcode.sdk.service.ScanCodeRecordVoService;
import com.biz.crm.cps.external.barcode.sdk.service.strategy.ScanCodeExceptionStrategy;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeExceptionStrategyVo;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeRecordVo;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BaseScanCodeExceptionStrategyImpl
implements ScanCodeExceptionStrategy {
    @Autowired
    private BarCodeLatestCirculationService barCodeLatestCirculationService;
    @Autowired
    private ScanCodeRecordService scanCodeRecordService;
    @Autowired
    private ScanCodeRecordVoService scanCodeRecordVoService;

    public ScanCodeExceptionStrategyVo scanCodeValidation(ScanCodeExceptionStrategyDto scanCodeExceptionStrategyDto) {
        ScanCodeExceptionStrategyVo scanCodeExceptionStrategyVo = new ScanCodeExceptionStrategyVo();
        BarCodeLatestCirculation barCodeLatestCirculation = this.barCodeLatestCirculationService.findByBarCodeAndParticipatorType(scanCodeExceptionStrategyDto.getBarCode(), scanCodeExceptionStrategyDto.getParticipatorType());
        if (Objects.nonNull((Object)barCodeLatestCirculation)) {
            scanCodeExceptionStrategyVo.setBarCodeParticipatorCode(barCodeLatestCirculation.getBarCodeParticipatorCode());
            if (!scanCodeExceptionStrategyDto.getScanParticipatorCode().equals(barCodeLatestCirculation.getBarCodeParticipatorCode())) {
                scanCodeExceptionStrategyVo.setScanCodeException(ScanCodeExceptionEnum.CROSS_CUSTOMER.getCode());
                scanCodeExceptionStrategyVo.setRemark(ScanCodeExceptionEnum.CROSS_CUSTOMER.getDes());
                return scanCodeExceptionStrategyVo;
            }
            if (ScanCodeExceptionEnum.NO.getCode().equals(barCodeLatestCirculation.getScanCodeException())) {
                scanCodeExceptionStrategyVo.setScanCodeException(ScanCodeExceptionEnum.REPEAT_SCAN.getCode());
                scanCodeExceptionStrategyVo.setRemark(ScanCodeExceptionEnum.REPEAT_SCAN.getDes());
                return scanCodeExceptionStrategyVo;
            }
            scanCodeExceptionStrategyVo.setScanCodeException(barCodeLatestCirculation.getScanCodeException());
            scanCodeExceptionStrategyVo.setRemark(ScanCodeExceptionEnum.getDesc((String)barCodeLatestCirculation.getScanCodeException()));
            return scanCodeExceptionStrategyVo;
        }
        ScanCodeRecord scanCodeRecord = this.scanCodeRecordService.findByBarCodeAndParticipatorType(scanCodeExceptionStrategyDto.getBarCode(), scanCodeExceptionStrategyDto.getParticipatorType(), ScanCodeExceptionEnum.NO.getCode());
        if (Objects.nonNull((Object)scanCodeRecord)) {
            scanCodeExceptionStrategyVo.setBarCodeParticipatorCode(scanCodeRecord.getBarCodeParticipatorCode());
            if (scanCodeExceptionStrategyDto.getScanParticipatorCode().equals(scanCodeRecord.getScanParticipatorCode())) {
                scanCodeExceptionStrategyVo.setScanCodeException(ScanCodeExceptionEnum.REPEAT_SCAN.getCode());
                scanCodeExceptionStrategyVo.setRemark(ScanCodeExceptionEnum.REPEAT_SCAN.getDes());
                return scanCodeExceptionStrategyVo;
            }
            scanCodeExceptionStrategyVo.setScanCodeException(ScanCodeExceptionEnum.CROSS_CUSTOMER.getCode());
            scanCodeExceptionStrategyVo.setRemark(ScanCodeExceptionEnum.CROSS_CUSTOMER.getDes());
            return scanCodeExceptionStrategyVo;
        }
        List scanCodeRecords = this.scanCodeRecordVoService.findByScanParticipatorCode(scanCodeExceptionStrategyDto.getScanParticipatorCode());
        List collect = scanCodeRecords.stream().filter(scanCodeRecord1 -> scanCodeRecord1.getFlatAncestors().contains(scanCodeExceptionStrategyDto.getBarCode())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)) {
            for (ScanCodeRecordVo recordVo : collect) {
                if (BarCodeTypeEnum.BOX.getFlag().equals(recordVo.getBarCodeType())) {
                    scanCodeExceptionStrategyVo.setBarCodeParticipatorCode(recordVo.getBarCodeParticipatorCode());
                    scanCodeExceptionStrategyVo.setScanCodeException(ScanCodeExceptionEnum.BOX.getCode());
                    scanCodeExceptionStrategyVo.setRemark(ScanCodeExceptionEnum.BOX.getDes());
                    return scanCodeExceptionStrategyVo;
                }
                if (!BarCodeTypeEnum.BOTTLE.getFlag().equals(recordVo.getBarCodeType()) || !BarCodeTypeEnum.BOX.getFlag().equals(scanCodeExceptionStrategyDto.getBarCodeType())) continue;
                scanCodeExceptionStrategyVo.setBarCodeParticipatorCode(recordVo.getBarCodeParticipatorCode());
                scanCodeExceptionStrategyVo.setScanCodeException(ScanCodeExceptionEnum.BOTTLE.getCode());
                scanCodeExceptionStrategyVo.setRemark(ScanCodeExceptionEnum.BOTTLE.getDes());
                return scanCodeExceptionStrategyVo;
            }
        }
        return null;
    }
}

