package com.biz.crm.cps.external.barcode.sdk.common.enums;


import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * @Description: 录入类型
 * @author songjingen
 **/
public enum EnterTypeEnum {
  /**
   * 编码与描述
   */
  MANUAL("1", "手动"),
  AUTO("2", "自动");

  private String code;
  private String des;

  EnterTypeEnum(String code, String des) {
    this.code = code;
    this.des = des;
  }

  public String getCode() {
    return code;
  }

  public String getDes() {
    return des;
  }

  /**
   * code转数组
   * @return
   */
  public static Set<String> codeToSet(){
    Set<String> codes = new HashSet<>();
    for (EnterTypeEnum enableStatusEnum : EnterTypeEnum.values()) {
      codes.add(enableStatusEnum.getCode());
    }
    return codes;
  }

  /**
   * 根据code获取文字描述
   * @param code
   * @return
   */
  public static String getDesc(String code) {
    if (!StringUtils.isEmpty(code)) {
      EnterTypeEnum[] values = EnterTypeEnum.values();
      for (EnterTypeEnum value : values) {
        if (value.code.equals(code)) {
          return value.des;
        }
      }
    }
    return null;
  }


  /**
   * 判断枚举中是否包含该code
   * @param code
   * @return
   */
  public static boolean contains(String code) {
    if (StringUtils.isEmpty(code)) {
      return false;
    }
    EnterTypeEnum[] values = EnterTypeEnum.values();
    for (EnterTypeEnum value : values) {
      if (value.getCode().equals(code)) {
        return true;
      }
    }
    return false;
  }

}

