package com.biz.crm.cps.external.barcode.sdk.common.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * @Description: 扫码参与者类型枚举
 * @author jerry7
 **/
public enum ParticipatorTypeEnum {
  /**
   * 编码与描述
   */
  C("c", "经销商"),
  TERMINAL("terminal", "终端"),
  CONSUMER("consumer", "消费者"),
  USER_GUIDE("user_guide", "导购");

  private String code;
  private String des;

  ParticipatorTypeEnum(String code, String des) {
    this.code = code;
    this.des = des;
  }

  public String getCode() {
    return code;
  }

  public String getDes() {
    return des;
  }

  /**
   * code转数组
   * @return
   */
  public static Set<String> codeToSet(){
    Set<String> codes = new HashSet<>();
    for (ParticipatorTypeEnum enableStatusEnum : ParticipatorTypeEnum.values()) {
      codes.add(enableStatusEnum.getCode());
    }
    return codes;
  }

  /**
   * 根据code获取文字描述
   * @param code
   * @return
   */
  public static String getDesc(String code) {
    if (!StringUtils.isEmpty(code)) {
      ParticipatorTypeEnum[] values = ParticipatorTypeEnum.values();
      for (ParticipatorTypeEnum value : values) {
        if (value.code.equals(code)) {
          return value.des;
        }
      }
    }
    return null;
  }


  /**
   * 判断枚举中是否包含该code
   * @param code
   * @return
   */
  public static boolean contains(String code) {
    if (StringUtils.isEmpty(code)) {
      return false;
    }
    ParticipatorTypeEnum[] values = ParticipatorTypeEnum.values();
    for (ParticipatorTypeEnum value : values) {
      if (value.getCode().equals(code)) {
        return true;
      }
    }
    return false;
  }

}

