package com.biz.crm.cps.external.barcode.sdk.common.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * @Description: 扫码预警
 *
 * @author songjingen
 */
public enum ScanCodeExceptionEnum {
  /** 编码与描述 */
  NO("0", "无",""),
  REPEAT_SCAN("1", "重复扫码",""),
  BOX("2", "已扫过箱码，对应的盒码作废！",""),
  BOTTLE("3", "已扫过盒码，对应的箱码作废！",""),
  DEALER_CROSS_CUSTOMER("4", "经销商跨客户扫码预警","跨客户预警"),
  TERMINAL_CROSS_CUSTOMER("5", "终端跨客户扫码预警","跨客户预警"),
  TERMINAL_CROSS_CHANNEL("6", "终端跨渠道扫码预警","跨渠道预警"),
  NOT_ASSIGN_TERMINAL("7", "非指定终端配置扫码预警","非指定终端预警"),
  NOT_ASSIGN_SUPPLY_PRODUCT("8", "非指定供货产品配置扫码预警","非供货产品预警"),
  TERMINAL_SCAN_LOCATION("9", "终端-扫码位置预警","扫码位置预警"),
  CUSTOMER_SCAN_LOCATION("10", "消费者-扫码位置预警","扫码位置预警"),
  NOT_SIGNED("11", "未签署该码对应的物料所绑定的分利协议",""),
  TERMINAL_ALREADY_STORAGE("12", "终端已入库此商品码，无法入库",""),
  TERMINAL_CODE_NOT_INBOUND("13", "此商品码经销商未入库预警","扫码流程预警"),
  TERMINAL_CODE_NOT_OUTBOUND("14", "此商品码经销商未出库预警","扫码流程预警"),
  NOT_STORAGE_PRODUCT("15", "此商品码尚未入库！",""),
  NO_ACTIVITY("16", "无可用的扫码活动！","");

  private String code;
  private String des;
  /**
   * 预警类型
   */
  private String type;

  ScanCodeExceptionEnum(String code, String des, String type) {
    this.code = code;
    this.des = des;
    this.type = type;
  }

  public String getCode() {
    return code;
  }

  public String getDes() {
    return des;
  }

  public String getType() {
    return type;
  }

  /**
   * code转数组
   *
   * @return
   */
  public static Set<String> codeToSet() {
    Set<String> codes = new HashSet<>();
    for (ScanCodeExceptionEnum enableStatusEnum : ScanCodeExceptionEnum.values()) {
      codes.add(enableStatusEnum.getCode());
    }
    return codes;
  }

  /**
   * 根据code获取文字描述
   *
   * @param code
   * @return
   */
  public static String getDesc(String code) {
    if (!StringUtils.isEmpty(code)) {
      ScanCodeExceptionEnum[] values = ScanCodeExceptionEnum.values();
      for (ScanCodeExceptionEnum value : values) {
        if (value.code.equals(code)) {
          return value.des;
        }
      }
    }
    return null;
  }

  /**
   * 根据code获取类型
   * @param code
   * @return
   */
  public static ScanCodeExceptionEnum findByCode(String code){
    if (!StringUtils.isEmpty(code)) {
      ScanCodeExceptionEnum[] values = ScanCodeExceptionEnum.values();
      for (ScanCodeExceptionEnum value : values) {
        if (value.code.equals(code)) {
          return value;
        }
      }
    }
    return null;
  }

  /**
   * 判断枚举中是否包含该code
   *
   * @param code
   * @return
   */
  public static boolean contains(String code) {
    if (StringUtils.isEmpty(code)) {
      return false;
    }
    ScanCodeExceptionEnum[] values = ScanCodeExceptionEnum.values();
    for (ScanCodeExceptionEnum value : values) {
      if (value.getCode().equals(code)) {
        return true;
      }
    }
    return false;
  }
}
