package com.biz.crm.cps.external.barcode.sdk.common.enums;

import java.util.stream.Stream;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 扫码记录统计查询类型枚举
 *
 * @author sunx
 * @date 2022/2/21
 */
@Getter
@AllArgsConstructor
public enum ScanCodeReportSearchTypeEnum {
  /** 扫码记录统计查询类型枚举 */
  ALL("ALL", "0", "全部", "0"),
  MONTH("month", "1", "月度", "1"),
  SEASON("season", "2", "季度", "2"),
  YEAR("year", "3", "年度", "3"),
  TODAY("today", "4", "今日", "4"),
  YESTERDAY("yesterday", "5", "昨日", "5"),
  WEEK("week", "6", "本周", "6"),
  ;
  /** 系统key */
  private String key;
  /** 字典编码 */
  private String dictCode;
  /** 字典值 */
  private String value;
  /** 字典排序 */
  private String order;

  /**
   * 根据字典编码获取枚举对象
   *
   * @param dictCode
   * @return
   */
  public static ScanCodeReportSearchTypeEnum findByDictCode(String dictCode) {
    return Stream.of(ScanCodeReportSearchTypeEnum.values())
        .filter(a -> a.getDictCode().equals(dictCode))
        .findFirst()
        .orElse(null);
  }
}
