package com.biz.crm.cps.external.barcode.sdk.common.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 扫码预警配置枚举
 *
 * @author jerry7
 **/
public enum ScanCodeWarningTypeEnum {
  /**
   * 编码与描述
   */
  ALLOW("allow", "1", "允许且记录"),
  NOT_ALLOWED("notAllowed", "2", "不允许且记录"),
  PASS("pass", "3", "不校验");

  private String key;

  private String flag;

  private String desc;

  ScanCodeWarningTypeEnum(String key, String flag, String desc) {
    this.key = key;
    this.flag = flag;
    this.desc = desc;
  }

  public String getKey() {
    return key;
  }

  public String getFlag() {
    return flag;
  }

  public String getDesc() {
    return desc;
  }

  /**
   * 判断枚举中是否包含该key
   *
   * @param key
   * @return
   */
  public static boolean contains(String key) {
    if (StringUtils.isEmpty(key)) {
      return false;
    }
    ScanCodeWarningTypeEnum[] values = ScanCodeWarningTypeEnum.values();
    for (ScanCodeWarningTypeEnum value : values) {
      if (value.getKey().equals(key)) {
        return true;
      }
    }
    return false;
  }

}

