package com.biz.crm.cps.external.barcode.sdk.common.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * @Description: 扫码类型
 * @author songjingen
 **/
public enum ScanTypeEnum {
  /**
   * 编码与描述
   */
  ENTER_WAREHOUSE("1", "入库"),
  BILL("2", "开单"),
  LUCK_DRAW("3", "抽奖"),
  OUT_WAREHOUSE("4", "出库");

  private String code;
  private String des;

  ScanTypeEnum(String code, String des) {
    this.code = code;
    this.des = des;
  }

  public String getCode() {
    return code;
  }

  public String getDes() {
    return des;
  }

  /**
   * code转数组
   * @return
   */
  public static Set<String> codeToSet(){
    Set<String> codes = new HashSet<>();
    for (ScanTypeEnum enableStatusEnum : ScanTypeEnum.values()) {
      codes.add(enableStatusEnum.getCode());
    }
    return codes;
  }

  /**
   * 根据code获取文字描述
   * @param code
   * @return
   */
  public static String getDesc(String code) {
    if (!StringUtils.isEmpty(code)) {
      ScanTypeEnum[] values = ScanTypeEnum.values();
      for (ScanTypeEnum value : values) {
        if (value.code.equals(code)) {
          return value.des;
        }
      }
    }
    return null;
  }


  /**
   * 判断枚举中是否包含该code
   * @param code
   * @return
   */
  public static boolean contains(String code) {
    if (StringUtils.isEmpty(code)) {
      return false;
    }
    ScanTypeEnum[] values = ScanTypeEnum.values();
    for (ScanTypeEnum value : values) {
      if (value.getCode().equals(code)) {
        return true;
      }
    }
    return false;
  }

}

