package com.biz.crm.cps.external.barcode.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 外部条形码实体类
 * @author songjingen
 */
@Data
@ApiModel(value = "Barcode", description = "外部条形码实体类")
public class BarCodeDto {

  /**
   * 码（完整码结构的码）
   */
  @ApiModelProperty("码（完整码结构的码）")
  private String barCode;

  /**
   * 所属父级码
   */
  @ApiModelProperty("所属父级码")
  private String parentBarCode;

  /**
   * 拉平祖级结构（如：父级码1,父级码2,当前码）
   */
  @ApiModelProperty(value = "拉平祖级结构（如：父级码1,父级码2,当前码）", required = false)
  private String flatAncestors;

  /**
   * 码类型：1-箱码，2-盒码，3-盖内码
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.BarCodeTypeEnum
   *
   */
  @ApiModelProperty("码类型：1-箱码，2-盒码，3-盖内码")
  private String barCodeType;

  /**
   * 商品唯一编码
   */
  @ApiModelProperty("商品唯一编码")
  private String productCode;

  /**
   * 下属码
   */
  @ApiModelProperty("下属码")
  private List<BarCodeDto> childrenBarCode;

  /**
   * 租户编号
   */
  @ApiModelProperty(name = "tenantCode", value = "租户编号", required = false)
  private String tenantCode;

  /**
   * 标准单位转换结果 标箱数值
   */
  @ApiModelProperty(value = "标准单位结果标箱数值", required = false)
  private BigDecimal standardUnitBoxValue;

  /**
   * 标准单位转换结果 标盒数值
   */
  @ApiModelProperty(value = "标准单位结果标盒数值", required = false)
  private BigDecimal standardUnitBottleValue;

  /**
   * 条码（明码）
   */
  @ApiModelProperty("条码（明码）")
  private String barCodeWhite;

}
