package com.biz.crm.cps.external.barcode.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 消费者扫码Dto
 * @author songjingen
 */
@Data
@ApiModel(value = "ConsumerScanCodeDto", description = "消费者扫码Dto")
public class ConsumerScanCodeDto {

  /**
   * 消费者外部id，消费者必传
   */
  @ApiModelProperty("消费者外部id，消费者必传")
  private String externalId;

  /**
   * 消费者手机号，消费者必传
   */
  @ApiModelProperty("消费者手机号，消费者必传")
  private String phone;

  /**
   * 消费者昵称，消费者必传
   */
  @ApiModelProperty("消费者昵称，消费者必传")
  private String nickname;

  /**
   * 盒码所属人参与者类型：(c-经销商，terminal-终端用户，consumer-消费者)
   */
  @ApiModelProperty("参与者类型：(c-经销商，terminal-终端用户，consumer-消费者)")
  private String participatorType;

  /**
   * 盒码所属人code
   */
  @ApiModelProperty("盒码所属人code")
  private String barCodeParticipatorCode;

}
