package com.biz.crm.cps.external.barcode.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 扫码异常策略dto
 * @author songjingen
 */
@Data
@ApiModel(value = "ScanCodeExceptionStrategyDto", description = "扫码异常策略dto")
public class ScanCodeExceptionStrategyDto {

  /**
   * 码
   */
  @ApiModelProperty("码")
  private String barCode;

  /**
   * 码类型：1-箱码，2-盒码，3-盖内码
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.BarCodeTypeEnum
   *
   */
  @ApiModelProperty("码类型：1-箱码，2-盒码，3-盖内码")
  private String barCodeType;

  /**
   * 参与者类型：(c-经销商，terminal-终端用户，consumer-消费者)
   */
  @ApiModelProperty("参与者类型：(c-经销商，terminal-终端用户，consumer-消费者)")
  private String participatorType;

  /**
   * 扫码人编码
   */
  @ApiModelProperty("扫码人编码")
  private String scanParticipatorCode;

  /**
   * 省编码
   */
  @ApiModelProperty("省编码")
  private String provinceCode;

  /**
   * 省名称
   */
  @ApiModelProperty("省名称")
  private String provinceName;

  /**
   * 市编码
   */
  @ApiModelProperty("市编码")
  private String cityCode;

  /**
   * 市名称
   */
  @ApiModelProperty("市名称")
  private String cityName;

  /**
   * 区编码
   */
  @ApiModelProperty("区编码")
  private String districtCode;

  /**
   * 区名称
   */
  @ApiModelProperty("区名称")
  private String districtName;

  /**
   * 经度
   */
  @ApiModelProperty("经度")
  private String longitude;

  /**
   * 纬度
   */
  @ApiModelProperty("纬度")
  private String latitude;

  /**
   * 商品唯一编码
   */
  @ApiModelProperty("商品唯一编码")
  private String productCode;

  /**
   * 扫码类型：1-入库，2-开单，3-抽奖
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.ScanTypeEnum
   */
  @ApiModelProperty("扫码类型：1-入库，2-开单，3-抽奖")
  private String scanType;

  /**
   * 经销商扫码出库管理终端编码
   */
  @ApiModelProperty("经销商扫码出库管理终端编码")
  private String terminalCode;

  /**
   * 经销商扫码出库关联渠道编码
   */
  @ApiModelProperty("经销商扫码出库关联渠道编码")
  private String channelCode;

}
