package com.biz.crm.cps.external.barcode.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 扫码记录实体类
 * @author songjingen
 */
@Data
@ApiModel(value = "ScanCodeRecord", description = "扫码记录实体类")
public class ScanCodeRecordDto {

  /**
   * 码
   */
  @ApiModelProperty("码")
  private String barCode;

  /**
   * 码类型：1-箱码，2-盒码，3-盖内码
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.BarCodeTypeEnum
   */
  @ApiModelProperty("码类型：1-箱码，2-盒码，3-盖内码")
  private String barCodeType;

  /**
   * 扫码类型：1-入库，2-开单，3-抽奖
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.ScanTypeEnum
   */
  @ApiModelProperty("扫码类型：1-入库，2-开单，3-抽奖")
  private String scanType;

  /**
   * 录入类型：1-手动，2-自动
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.EnterTypeEnum
   */
  @ApiModelProperty("录入类型：1-手动，2-自动")
  private String enterType;

  /**
   * 参与者类型：(c-经销商，terminal-终端用户，consumer-消费者)
   */
  @ApiModelProperty("参与者类型：(c-经销商，terminal-终端用户，consumer-消费者)")
  private String participatorType;

  /**
   * 码流转参与者编码
   */
  @ApiModelProperty("码流转参与者编码")
  private String barCodeParticipatorCode;


  /**
   * 省编码
   */
  @ApiModelProperty("省编码")
  private String provinceCode;

  /**
   * 省名称
   */
  @ApiModelProperty("省名称")
  private String provinceName;

  /**
   * 市编码
   */
  @ApiModelProperty("市编码")
  private String cityCode;

  /**
   * 市名称
   */
  @ApiModelProperty("市名称")
  private String cityName;

  /**
   * 区编码
   */
  @ApiModelProperty("区编码")
  private String districtCode;

  /**
   * 区名称
   */
  @ApiModelProperty("区名称")
  private String districtName;

  /**
   * 经度
   */
  @ApiModelProperty("经度")
  private String longitude;

  /**
   * 纬度
   */
  @ApiModelProperty("纬度")
  private String latitude;

  /**
   * 扫码异常
   */
  @ApiModelProperty("扫码异常")
  private String scanCodeException;

  /**
   * 商品唯一码
   */
  @ApiModelProperty("商品唯一码")
  private String productCode;

  /**
   * 所属父级码
   */
  @ApiModelProperty("所属父级码")
  private String parentBarCode;

  /**
   * 扫码人编码 经销商编码  终端编码 导购编码 消费者编码
   */
  @ApiModelProperty("扫码人编码")
  private String scanParticipatorCode;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  private String remark;

  /**
   * 消费者扫码信息
   */
  @ApiModelProperty("消费者扫码信息")
  private ConsumerScanCodeDto consumerScanCodeDto;

  /**
   * 扫码预警
   */
  @ApiModelProperty("扫码预警")
  private String scanCodeWarning;

  /**
   * 经销商扫码出库管理终端编码
   */
  @ApiModelProperty("经销商扫码出库管理终端编码")
  private String terminalCode;

  /**
   * 经销商扫码出库关联渠道编码
   */
  @ApiModelProperty("经销商扫码出库关联渠道编码")
  private String channelCode;

  /**
   * 是否进行分利 y/n
   */
  @ApiModelProperty("是否进行分利y/n")
  private String notify;

  /** 扫码活动编码 */
  @ApiModelProperty(value = "扫码活动编码",hidden = true)
  private String scanActCode;
}
