package com.biz.crm.cps.external.barcode.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 扫码记录事件Dto
 * @author songjingen
 */
@Data
@ApiModel(value = "ScanCodeRecordEventDto", description = "扫码记录事件Dto")
public class ScanCodeRecordEventDto {

  /**
   * 扫码记录编码
   */
  @ApiModelProperty("扫码记录编码")
  private String recordCode;

  /**
   * 码
   */
  @ApiModelProperty("码")
  private String barCode;

  /**
   * 码类型：1-箱码，2-盒码，3-盖内码
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.BarCodeTypeEnum
   */
  @ApiModelProperty("码类型：1-箱码，2-盒码，3-盖内码")
  private String barCodeType;

  /**
   * 参与者类型：(c-经销商，terminal-终端用户，consumer-消费者)
   */
  @ApiModelProperty("参与者类型：(c-经销商，terminal-终端用户，consumer-消费者)")
  private String participatorType;

  /**
   * 码流转参与者编码
   */
  @ApiModelProperty("码流转参与者编码")
  private String barCodeParticipatorCode;

  /**
   * 商品唯一码
   */
  @ApiModelProperty("商品唯一码")
  private String productCode;

  /**
   * 扫码异常
   */
  @ApiModelProperty("扫码异常")
  private String scanCodeException;

  /**
   * 扫码人编码
   */
  @ApiModelProperty("扫码人编码")
  private String scanParticipatorCode;

  /**
   * 消费者扫码信息
   */
  @ApiModelProperty("消费者扫码信息")
  private ConsumerScanCodeDto consumerScanCodeDto;

  /** 扫码活动编码 */
  @ApiModelProperty(value = "扫码活动编码",hidden = true)
  private String scanActCode;

  /** 红包发张账户编码 */
  @ApiModelProperty(value = "红包发张账户编码",hidden = true)
  private String accountCode;
}
